import { Result } from '../Core/Result';
import { ValueObject } from '../Core/ValueObject';
import { ContentTypeProps } from './ContentTypeProps';
export declare class ContentType extends ValueObject<ContentTypeProps> {
    static readonly TYPES: {
        Any: string;
        Item: string;
        KeySystemItemsKey: string;
        KeySystemRootKey: string;
        TrustedContact: string;
        VaultListing: string;
        RootKey: string;
        ItemsKey: string;
        EncryptedStorage: string;
        Note: string;
        Tag: string;
        SmartView: string;
        Component: string;
        Editor: string;
        ActionsExtension: string;
        UserPrefs: string;
        HistorySession: string;
        Theme: string;
        File: string;
        FilesafeCredentials: string;
        FilesafeFileMetadata: string;
        FilesafeIntegration: string;
        ExtensionRepo: string;
    };
    private readonly displayNamesMap;
    get value(): string | null;
    private constructor();
    static create(type: string | null): Result<ContentType>;
    getDisplayName(): string | null;
}
//# sourceMappingURL=ContentType.d.ts.map