"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionToken = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const Validator_1 = require("../Core/Validator");
class SessionToken extends ValueObject_1.ValueObject {
    get value() {
        return this.props.value;
    }
    get expiresAt() {
        return this.props.expiresAt;
    }
    constructor(props) {
        super(props);
    }
    static create(value, expiresAt) {
        if (Validator_1.Validator.isNotEmpty(value).isFailed()) {
            return Result_1.Result.fail('Could not create session token. Token value is empty');
        }
        if (Validator_1.Validator.isNotEmpty(expiresAt).isFailed()) {
            return Result_1.Result.fail('Could not create session token. Token expiration is empty');
        }
        return Result_1.Result.ok(new SessionToken({ value, expiresAt }));
    }
}
exports.SessionToken = SessionToken;
