"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Session = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
class Session extends ValueObject_1.ValueObject {
    get accessToken() {
        return this.props.accessToken;
    }
    get refreshToken() {
        return this.props.refreshToken;
    }
    isReadOnly() {
        return this.props.readonlyAccess || false;
    }
    constructor(props) {
        super(props);
    }
    static create(accessToken, refreshToken, readonlyAccess) {
        return Result_1.Result.ok(new Session({ accessToken, refreshToken, readonlyAccess }));
    }
}
exports.Session = Session;
