"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegacySession = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const Validator_1 = require("../Core/Validator");
class LegacySession extends ValueObject_1.ValueObject {
    get accessToken() {
        return this.props.token;
    }
    constructor(props) {
        super(props);
    }
    static create(token) {
        if (Validator_1.Validator.isNotEmpty(token).isFailed()) {
            return Result_1.Result.fail('Could not create legacy session. Token value is empty');
        }
        return Result_1.Result.ok(new LegacySession({ token }));
    }
}
exports.LegacySession = LegacySession;
