import { ChallengeService } from '../Challenge/ChallengeService';
import { SNRootKey } from '@standardnotes/encryption';
import { HttpResponse, SignInResponse } from '@standardnotes/responses';
import { ItemManager } from '../../../../Services/Items/ItemManager';
import { KeyParamsOrigination } from '@standardnotes/common';
import { AbstractService, AlertService, DeinitSource, InternalEventBusInterface, UserClientInterface, EncryptionService } from '@standardnotes/services';
import { SNApiService } from './../Api/ApiService';
import { SNProtectionService } from '../Protection/ProtectionService';
import { SNSessionManager } from '../Session/SessionManager';
import { DiskStorageService } from '../../../../Services/Storage/DiskStorageService';
import { SNSyncService } from '../Sync/SyncService';
import { UserRegistrationResponseBody } from '@standardnotes/api';
export declare type CredentialsChangeFunctionResponse = {
    error?: {
        message: string;
    };
};
export declare type AccountServiceResponse = HttpResponse;
export declare enum AccountEvent {
    SignedInOrRegistered = "SignedInOrRegistered",
    SignedOut = "SignedOut"
}
declare type AccountEventData = {
    source: DeinitSource;
};
export declare class UserService extends AbstractService<AccountEvent, AccountEventData> implements UserClientInterface {
    private sessionManager;
    private syncService;
    private storageService;
    private itemManager;
    private protocolService;
    private alertService;
    private challengeService;
    private protectionService;
    private apiService;
    protected internalEventBus: InternalEventBusInterface;
    private signingIn;
    private registering;
    constructor(sessionManager: SNSessionManager, syncService: SNSyncService, storageService: DiskStorageService, itemManager: ItemManager, protocolService: EncryptionService, alertService: AlertService, challengeService: ChallengeService, protectionService: SNProtectionService, apiService: SNApiService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    /**
     *  @param mergeLocal  Whether to merge existing offline data into account. If false,
     *                     any pre-existing data will be fully deleted upon success.
     */
    register(email: string, password: string, ephemeral?: boolean, mergeLocal?: boolean): Promise<UserRegistrationResponseBody>;
    /**
     * @param mergeLocal  Whether to merge existing offline data into account.
     * If false, any pre-existing data will be fully deleted upon success.
     */
    signIn(email: string, password: string, strict?: boolean, ephemeral?: boolean, mergeLocal?: boolean, awaitSync?: boolean): Promise<AccountServiceResponse>;
    deleteAccount(): Promise<{
        error: boolean;
        message?: string;
    }>;
    /**
     * A sign in request that occurs while the user was previously signed in, to correct
     * for missing keys or storage values. Unlike regular sign in, this doesn't worry about
     * performing one of marking all items as needing sync or deleting all local data.
     */
    correctiveSignIn(rootKey: SNRootKey): Promise<HttpResponse | SignInResponse>;
    /**
     * @param passcode - Changing the account password or email requires the local
     * passcode if configured (to rewrap the account key with passcode). If the passcode
     * is not passed in, the user will be prompted for the passcode. However if the consumer
     * already has reference to the passcode, they can pass it in here so that the user
     * is not prompted again.
     */
    changeCredentials(parameters: {
        currentPassword: string;
        origination: KeyParamsOrigination;
        validateNewPasswordStrength: boolean;
        newEmail?: string;
        newPassword?: string;
        passcode?: string;
    }): Promise<CredentialsChangeFunctionResponse>;
    signOut(force?: boolean, source?: DeinitSource): Promise<void>;
    performProtocolUpgrade(): Promise<{
        success?: true;
        canceled?: true;
        error?: {
            message: string;
        };
    }>;
    addPasscode(passcode: string): Promise<boolean>;
    removePasscode(): Promise<boolean>;
    /**
     * @returns whether the passcode was successfuly changed or not
     */
    changePasscode(newPasscode: string, origination?: KeyParamsOrigination): Promise<boolean>;
    private setPasscodeWithoutWarning;
    private removePasscodeWithoutWarning;
    /**
     * Allows items keys to be rewritten to local db on local credential status change,
     * such as if passcode is added, changed, or removed.
     * This allows IndexedDB unencrypted logs to be deleted
     * `deletePayloads` will remove data from backing store,
     * but not from working memory See:
     * https://github.com/standardnotes/desktop/issues/131
     */
    private rewriteItemsKeys;
    private lockSyncing;
    private unlockSyncing;
    private clearDatabase;
    private performCredentialsChange;
    private recomputeRootKeysForCredentialChange;
}
export {};
