import { Error, RawSyncResponse } from '@standardnotes/responses';
import { ServerSyncSavedContextualPayload, FilteredServerItem } from '@standardnotes/models';
export declare class ServerSyncResponse {
    readonly rawResponse: RawSyncResponse;
    readonly savedPayloads: ServerSyncSavedContextualPayload[];
    readonly retrievedPayloads: FilteredServerItem[];
    readonly uuidConflictPayloads: FilteredServerItem[];
    readonly dataConflictPayloads: FilteredServerItem[];
    readonly rejectedPayloads: FilteredServerItem[];
    constructor(rawResponse: RawSyncResponse);
    get error(): Error | undefined;
    get status(): number;
    get lastSyncToken(): string | undefined;
    get paginationToken(): string | undefined;
    get numberOfItemsInvolved(): number;
    private get allFullyFormedPayloads();
    private get rawUuidConflictItems();
    private get rawDataConflictItems();
    private get rawRejectedPayloads();
    private get rawConflictObjects();
    get hasError(): boolean;
}
