import { SettingsList } from './SettingsList';
import { SettingName, SensitiveSettingName, SubscriptionSettingName } from '@standardnotes/settings';
import { User } from '@standardnotes/responses';
import { SettingsServerInterface } from './SettingsServerInterface';
/**
 * SettingsGateway coordinates communication with the API service
 * wrapping the userUuid provision for simpler consumption
 */
export declare class SettingsGateway {
    private readonly settingsApi;
    private readonly userProvider;
    constructor(settingsApi: SettingsServerInterface, userProvider: {
        getUser: () => User | undefined;
    });
    isReadyForModification(): boolean;
    private getUser;
    private get userUuid();
    listSettings(): Promise<SettingsList>;
    getSetting(name: SettingName): Promise<string | undefined>;
    getSubscriptionSetting(name: SubscriptionSettingName): Promise<string | undefined>;
    getDoesSensitiveSettingExist(name: SensitiveSettingName): Promise<boolean>;
    updateSetting(name: SettingName, payload: string, sensitive: boolean): Promise<void>;
    deleteSetting(name: SettingName): Promise<void>;
    deinit(): void;
}
