import { AlertService, AbstractService, InternalEventBusInterface, DiagnosticInfo, EncryptionService } from '@standardnotes/services';
import { Base64String } from '@standardnotes/sncrypto-common';
import { ClientDisplayableError } from '@standardnotes/responses';
import { SNRootKey } from '@standardnotes/encryption';
import { RemoteSession } from './Sessions/Types';
import { Session } from './Sessions/Session';
import { SessionsClientInterface } from './SessionsClientInterface';
import { SNApiService } from '../Api/ApiService';
import { DiskStorageService } from '../Storage/DiskStorageService';
import { SNWebSocketsService } from '../Api/WebsocketsService';
import { Subscription } from '@standardnotes/security';
import { UuidString } from '../../../../Types/UuidString';
import * as Common from '@standardnotes/common';
import * as Responses from '@standardnotes/responses';
import { ChallengeService } from '../Challenge';
import { HttpServiceInterface, UserApiServiceInterface, UserRegistrationResponseBody } from '@standardnotes/api';
export declare const MINIMUM_PASSWORD_LENGTH = 8;
export declare const MissingAccountParams = "missing-params";
declare type SessionManagerResponse = {
    response: Responses.HttpResponse;
    rootKey?: SNRootKey;
    keyParams?: Common.AnyKeyParamsContent;
};
export declare enum SessionEvent {
    Restored = "SessionRestored",
    Revoked = "SessionRevoked"
}
/**
 * The session manager is responsible for loading initial user state, and any relevant
 * server credentials, such as the session token. It also exposes methods for registering
 * for a new account, signing into an existing one, or changing an account password.
 */
export declare class SNSessionManager extends AbstractService<SessionEvent> implements SessionsClientInterface {
    private diskStorageService;
    private apiService;
    private userApiService;
    private alertService;
    private protocolService;
    private challengeService;
    private webSocketsService;
    private httpService;
    protected internalEventBus: InternalEventBusInterface;
    private user?;
    private isSessionRenewChallengePresented;
    constructor(diskStorageService: DiskStorageService, apiService: SNApiService, userApiService: UserApiServiceInterface, alertService: AlertService, protocolService: EncryptionService, challengeService: ChallengeService, webSocketsService: SNWebSocketsService, httpService: HttpServiceInterface, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    private setUser;
    initializeFromDisk(): Promise<void>;
    private setSession;
    online(): boolean;
    offline(): boolean;
    getUser(): Responses.User | undefined;
    getSureUser(): Responses.User;
    getSession(): Session | undefined;
    signOut(): Promise<void>;
    isSignedIn(): boolean;
    isSignedIntoFirstPartyServer(): boolean;
    reauthenticateInvalidSession(cancelable?: boolean, onResponse?: (response: Responses.HttpResponse) => void): Promise<void>;
    getSubscription(): Promise<ClientDisplayableError | Subscription>;
    getAvailableSubscriptions(): Promise<Responses.AvailableSubscriptions | ClientDisplayableError>;
    private promptForMfaValue;
    register(email: string, password: string, ephemeral: boolean): Promise<UserRegistrationResponseBody>;
    private retrieveKeyParams;
    signIn(email: string, password: string, strict?: boolean, ephemeral?: boolean, minAllowedVersion?: Common.ProtocolVersion): Promise<SessionManagerResponse>;
    private performSignIn;
    bypassChecksAndSignInWithRootKey(email: string, rootKey: SNRootKey, ephemeral?: boolean): Promise<Responses.SignInResponse | Responses.HttpResponse>;
    changeCredentials(parameters: {
        currentServerPassword: string;
        newRootKey: SNRootKey;
        wrappingKey?: SNRootKey;
        newEmail?: string;
    }): Promise<SessionManagerResponse>;
    getSessionsList(): Promise<(Responses.HttpResponse & {
        data: RemoteSession[];
    }) | Responses.HttpResponse>;
    revokeSession(sessionId: UuidString): Promise<Responses.HttpResponse>;
    revokeAllOtherSessions(): Promise<void>;
    private processChangeCredentialsResponse;
    createDemoShareToken(): Promise<Base64String | ClientDisplayableError>;
    private decodeDemoShareToken;
    populateSessionFromDemoShareToken(token: Base64String): Promise<void>;
    private populateSession;
    private handleAuthResponse;
    /**
     * @deprecated use handleAuthResponse instead
     */
    private handleSuccessAuthResponse;
    getDiagnostics(): Promise<DiagnosticInfo | undefined>;
}
export {};
