import { Challenge } from './../Challenge/Challenge';
import { ChallengeService } from './../Challenge/ChallengeService';
import { DecryptedItem } from '@standardnotes/models';
import { DiskStorageService } from '../../../../Services/Storage/DiskStorageService';
import { AbstractService, InternalEventBusInterface, ApplicationStage, DiagnosticInfo, ChallengeReason, EncryptionService } from '@standardnotes/services';
import { ProtectionsClientInterface } from './ClientInterface';
import { MobileUnlockTiming, TimingDisplayOption } from './MobileUnlockTiming';
export declare enum ProtectionEvent {
    UnprotectedSessionBegan = "UnprotectedSessionBegan",
    UnprotectedSessionExpired = "UnprotectedSessionExpired"
}
export declare const ProposedSecondsToDeferUILevelSessionExpirationDuringActiveInteraction = 30;
export declare enum UnprotectedAccessSecondsDuration {
    OneMinute = 60,
    FiveMinutes = 300,
    OneHour = 3600,
    OneWeek = 604800
}
export declare function isValidProtectionSessionLength(number: unknown): boolean;
export declare const ProtectionSessionDurations: {
    valueInSeconds: UnprotectedAccessSecondsDuration;
    label: string;
}[];
/**
 * Enforces certain actions to require extra authentication,
 * like viewing a protected note, as well as managing how long that
 * authentication should be valid for.
 */
export declare class SNProtectionService extends AbstractService<ProtectionEvent> implements ProtectionsClientInterface {
    private protocolService;
    private challengeService;
    private storageService;
    protected internalEventBus: InternalEventBusInterface;
    private sessionExpiryTimeout;
    private mobilePasscodeTiming;
    private mobileBiometricsTiming;
    constructor(protocolService: EncryptionService, challengeService: ChallengeService, storageService: DiskStorageService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    handleApplicationStage(stage: ApplicationStage): Promise<void>;
    hasProtectionSources(): boolean;
    hasUnprotectedAccessSession(): boolean;
    hasBiometricsEnabled(): boolean;
    enableBiometrics(): boolean;
    disableBiometrics(): Promise<boolean>;
    createLaunchChallenge(): Challenge | undefined;
    authorizeProtectedActionForItems<T extends DecryptedItem>(items: T[], challengeReason: ChallengeReason): Promise<T[]>;
    authorizeItemAccess(item: DecryptedItem): Promise<boolean>;
    authorizeAddingPasscode(): Promise<boolean>;
    authorizeChangingPasscode(): Promise<boolean>;
    authorizeRemovingPasscode(): Promise<boolean>;
    authorizeSearchingProtectedNotesText(): Promise<boolean>;
    authorizeFileImport(): Promise<boolean>;
    authorizeBackupCreation(): Promise<boolean>;
    authorizeMfaDisable(): Promise<boolean>;
    authorizeAutolockIntervalChange(): Promise<boolean>;
    authorizeSessionRevoking(): Promise<boolean>;
    authorizeAction(reason: ChallengeReason, { fallBackToAccountPassword, requireAccountPassword }?: {
        fallBackToAccountPassword?: boolean | undefined;
        requireAccountPassword?: boolean | undefined;
    }): Promise<boolean>;
    getMobilePasscodeTimingOptions(): TimingDisplayOption[];
    getMobileBiometricsTimingOptions(): TimingDisplayOption[];
    getMobileBiometricsTiming(): MobileUnlockTiming | undefined;
    getMobilePasscodeTiming(): MobileUnlockTiming | undefined;
    setMobileBiometricsTiming(timing: MobileUnlockTiming): void;
    setMobilePasscodeTiming(timing: MobileUnlockTiming): void;
    setMobileScreenshotPrivacyEnabled(isEnabled: boolean): void;
    getMobileScreenshotPrivacyEnabled(): boolean;
    private validateOrRenewSession;
    getSessionExpiryDate(): Date;
    clearSession(): Promise<void>;
    private setSessionExpiryDate;
    private getLastSessionLength;
    private setSessionLength;
    private updateSessionExpiryTimer;
    getDiagnostics(): Promise<DiagnosticInfo | undefined>;
}
