import { PrefKey, PrefValue } from '@standardnotes/models';
import { ItemManager } from '../Items/ItemManager';
import { SNSingletonManager } from '../Singleton/SingletonManager';
import { SNSyncService } from '../Sync/SyncService';
import { AbstractService, InternalEventBusInterface, ApplicationStage, PreferenceServiceInterface, PreferencesServiceEvent } from '@standardnotes/services';
export declare class SNPreferencesService extends AbstractService<PreferencesServiceEvent> implements PreferenceServiceInterface {
    private singletonManager;
    private itemManager;
    private syncService;
    protected internalEventBus: InternalEventBusInterface;
    private shouldReload;
    private reloading;
    private preferences?;
    private removeItemObserver?;
    private removeSyncObserver?;
    constructor(singletonManager: SNSingletonManager, itemManager: ItemManager, syncService: SNSyncService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    handleApplicationStage(stage: ApplicationStage): Promise<void>;
    getValue<K extends PrefKey>(key: K, defaultValue: PrefValue[K] | undefined): PrefValue[K] | undefined;
    getValue<K extends PrefKey>(key: K, defaultValue: PrefValue[K]): PrefValue[K];
    setValue<K extends PrefKey>(key: K, value: PrefValue[K]): Promise<void>;
    private reload;
}
