import { SNHistoryManager } from './../History/HistoryManager';
import { AbstractService, InternalEventBusInterface, SyncOptions, ChallengeReason, MutatorClientInterface } from '@standardnotes/services';
import { EncryptionProviderInterface } from '@standardnotes/encryption';
import { ClientDisplayableError } from '@standardnotes/responses';
import { ContentType } from '@standardnotes/common';
import { ItemManager } from '../Items';
import { PayloadManager } from '../Payloads/PayloadManager';
import { SNComponentManager } from '../ComponentManager/ComponentManager';
import { SNProtectionService } from '../Protection/ProtectionService';
import { SNSyncService } from '../Sync';
import { ChallengeService } from '../Challenge';
import { BackupFile, DecryptedItemInterface, DecryptedItemMutator, EncryptedItemInterface, FileItem, ItemContent, PayloadEmitSource, SmartView, SNComponent, SNNote, SNTag, TransactionalMutation } from '@standardnotes/models';
export declare class MutatorService extends AbstractService implements MutatorClientInterface {
    private itemManager;
    private syncService;
    private protectionService;
    private encryption;
    private payloadManager;
    private challengeService;
    private componentManager;
    private historyService;
    protected internalEventBus: InternalEventBusInterface;
    constructor(itemManager: ItemManager, syncService: SNSyncService, protectionService: SNProtectionService, encryption: EncryptionProviderInterface, payloadManager: PayloadManager, challengeService: ChallengeService, componentManager: SNComponentManager, historyService: SNHistoryManager, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    insertItem(item: DecryptedItemInterface): Promise<DecryptedItemInterface>;
    changeAndSaveItem<M extends DecryptedItemMutator = DecryptedItemMutator>(itemToLookupUuidFor: DecryptedItemInterface, mutate: (mutator: M) => void, updateTimestamps?: boolean, emitSource?: PayloadEmitSource, syncOptions?: SyncOptions): Promise<DecryptedItemInterface | undefined>;
    changeAndSaveItems<M extends DecryptedItemMutator = DecryptedItemMutator>(itemsToLookupUuidsFor: DecryptedItemInterface[], mutate: (mutator: M) => void, updateTimestamps?: boolean, emitSource?: PayloadEmitSource, syncOptions?: SyncOptions): Promise<void>;
    changeItem<M extends DecryptedItemMutator>(itemToLookupUuidFor: DecryptedItemInterface, mutate: (mutator: M) => void, updateTimestamps?: boolean): Promise<DecryptedItemInterface | undefined>;
    changeItems<M extends DecryptedItemMutator = DecryptedItemMutator>(itemsToLookupUuidsFor: DecryptedItemInterface[], mutate: (mutator: M) => void, updateTimestamps?: boolean): Promise<(DecryptedItemInterface | undefined)[]>;
    runTransactionalMutations(transactions: TransactionalMutation[], emitSource?: PayloadEmitSource, payloadSourceKey?: string): Promise<(DecryptedItemInterface | undefined)[]>;
    runTransactionalMutation(transaction: TransactionalMutation, emitSource?: PayloadEmitSource, payloadSourceKey?: string): Promise<DecryptedItemInterface | undefined>;
    protectItems<M extends DecryptedItemMutator, I extends DecryptedItemInterface>(items: I[]): Promise<I[]>;
    unprotectItems<M extends DecryptedItemMutator, I extends DecryptedItemInterface>(items: I[], reason: ChallengeReason): Promise<I[] | undefined>;
    protectNote(note: SNNote): Promise<SNNote>;
    unprotectNote(note: SNNote): Promise<SNNote | undefined>;
    protectNotes(notes: SNNote[]): Promise<SNNote[]>;
    unprotectNotes(notes: SNNote[]): Promise<SNNote[]>;
    protectFile(file: FileItem): Promise<FileItem>;
    unprotectFile(file: FileItem): Promise<FileItem | undefined>;
    mergeItem(item: DecryptedItemInterface, source: PayloadEmitSource): Promise<DecryptedItemInterface>;
    createTemplateItem<C extends ItemContent = ItemContent, I extends DecryptedItemInterface<C> = DecryptedItemInterface<C>>(contentType: ContentType, content?: C): I;
    setItemNeedsSync(item: DecryptedItemInterface, updateTimestamps?: boolean): Promise<DecryptedItemInterface | undefined>;
    setItemsNeedsSync(items: DecryptedItemInterface[]): Promise<(DecryptedItemInterface | undefined)[]>;
    deleteItem(item: DecryptedItemInterface | EncryptedItemInterface): Promise<void>;
    deleteItems(items: (DecryptedItemInterface | EncryptedItemInterface)[]): Promise<void>;
    emptyTrash(): Promise<void>;
    duplicateItem<T extends DecryptedItemInterface>(item: T, additionalContent?: Partial<T['content']>): Promise<T>;
    migrateTagsToFolders(): Promise<unknown>;
    setTagParent(parentTag: SNTag, childTag: SNTag): Promise<void>;
    unsetTagParent(childTag: SNTag): Promise<void>;
    findOrCreateTag(title: string): Promise<SNTag>;
    /** Creates and returns the tag but does not run sync. Callers must perform sync. */
    createTagOrSmartView(title: string): Promise<SNTag | SmartView>;
    toggleComponent(component: SNComponent): Promise<void>;
    toggleTheme(theme: SNComponent): Promise<void>;
    importData(data: BackupFile, awaitSync?: boolean): Promise<{
        affectedItems: DecryptedItemInterface[];
        errorCount: number;
    } | {
        error: ClientDisplayableError;
    }>;
}
