import { SNSettingsService } from '../Settings';
import { PureCryptoInterface } from '@standardnotes/sncrypto-common';
import { SNFeaturesService } from '../Features/FeaturesService';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
export declare class SNMfaService extends AbstractService {
    private settingsService;
    private crypto;
    private featuresService;
    protected internalEventBus: InternalEventBusInterface;
    constructor(settingsService: SNSettingsService, crypto: PureCryptoInterface, featuresService: SNFeaturesService, internalEventBus: InternalEventBusInterface);
    private saveMfaSetting;
    isMfaActivated(): Promise<boolean>;
    generateMfaSecret(): Promise<string>;
    getOtpToken(secret: string): Promise<string>;
    enableMfa(secret: string, otpToken: string): Promise<void>;
    disableMfa(): Promise<void>;
    isMfaFeatureAvailable(): boolean;
    deinit(): void;
}
