import { UuidString } from '../../../../Types/UuidString';
import { ItemManager } from '../../../../Services/Items/ItemManager';
import { SNHttpService } from '../Api/HttpService';
import { SNSettingsService } from '../Settings/SNSettingsService';
import { ListedClientInterface } from './ListedClientInterface';
import { SNApiService } from '../Api/ApiService';
import { ListedAccount, ListedAccountInfo } from '@standardnotes/responses';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
export declare class ListedService extends AbstractService implements ListedClientInterface {
    private apiService;
    private itemManager;
    private settingsService;
    private httpSerivce;
    protected internalEventBus: InternalEventBusInterface;
    constructor(apiService: SNApiService, itemManager: ItemManager, settingsService: SNSettingsService, httpSerivce: SNHttpService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    canRegisterNewListedAccount(): boolean;
    /**
     * Account creation is asyncronous on the backend due to message-based nature of architecture.
     * In order to get the newly created account, we poll the server to check for new accounts.
     */
    requestNewListedAccount(): Promise<ListedAccount | undefined>;
    getListedAccounts(): Promise<ListedAccount[]>;
    getListedAccountInfo(account: ListedAccount, inContextOfItem?: UuidString): Promise<ListedAccountInfo | undefined>;
    private getSettingsBasedListedAccounts;
    private getLegacyListedAccounts;
}
