import { SNRootKeyParams } from '@standardnotes/encryption';
import { EncryptedTransferPayload, EncryptedPayloadInterface, DecryptedPayloadInterface, ItemsKeyContent, RootKeyInterface } from '@standardnotes/models';
import { UuidString } from '../../../../Types';
export declare type UndecryptableItemsStorage = Record<UuidString, EncryptedTransferPayload>;
export declare type KeyRecoveryOperationSuccessResult = {
    rootKey: RootKeyInterface;
    decryptedItemsKey: DecryptedPayloadInterface<ItemsKeyContent>;
    replaceLocalRootKeyWithResult: boolean;
};
export declare type KeyRecoveryOperationFailResult = {
    aborted: boolean;
};
export declare type KeyRecoveryOperationResult = KeyRecoveryOperationSuccessResult | KeyRecoveryOperationFailResult;
export declare function isSuccessResult(x: KeyRecoveryOperationResult): x is KeyRecoveryOperationSuccessResult;
export declare type DecryptionQueueItem = {
    encryptedKey: EncryptedPayloadInterface;
    keyParams: SNRootKeyParams;
};
export declare enum KeyRecoveryEvent {
    KeysRecovered = "KeysRecovered"
}
