import { UserService } from '../User/UserService';
import { SNApiService } from '../Api/ApiService';
import { RoleName } from '@standardnotes/common';
import { ItemManager } from '../Items/ItemManager';
import { PureCryptoInterface } from '@standardnotes/sncrypto-common';
import { SNSessionManager } from '../../../../Services/Session/SessionManager';
import { SNSettingsService } from '../Settings';
import { DiskStorageService } from '../Storage/DiskStorageService';
import { SNSyncService } from '../Sync/SyncService';
import { SNWebSocketsService } from '../Api/WebsocketsService';
import { UuidString } from '../../../../Types/UuidString';
import * as FeaturesImports from '@standardnotes/features';
import * as Models from '@standardnotes/models';
import { AbstractService, AlertService, ApplicationStage, DiagnosticInfo, FeaturesClientInterface, FeaturesEvent, FeatureStatus, InternalEventBusInterface, InternalEventHandlerInterface, InternalEventInterface, SetOfflineFeaturesFunctionResponse } from '@standardnotes/services';
export declare class SNFeaturesService extends AbstractService<FeaturesEvent> implements FeaturesClientInterface, InternalEventHandlerInterface {
    private storageService;
    private apiService;
    private itemManager;
    private webSocketsService;
    private settingsService;
    private userService;
    private syncService;
    private alertService;
    private sessionManager;
    private crypto;
    protected internalEventBus: InternalEventBusInterface;
    private deinited;
    private roles;
    private features;
    private enabledExperimentalFeatures;
    private removeWebSocketsServiceObserver;
    private removefeatureReposObserver;
    private removeSignInObserver;
    private needsInitialFeaturesUpdate;
    private completedSuccessfulFeaturesRetrieval;
    constructor(storageService: DiskStorageService, apiService: SNApiService, itemManager: ItemManager, webSocketsService: SNWebSocketsService, settingsService: SNSettingsService, userService: UserService, syncService: SNSyncService, alertService: AlertService, sessionManager: SNSessionManager, crypto: PureCryptoInterface, internalEventBus: InternalEventBusInterface);
    handleEvent(event: InternalEventInterface): Promise<void>;
    handleApplicationStage(stage: ApplicationStage): Promise<void>;
    private addDarkTheme;
    enableExperimentalFeature(identifier: FeaturesImports.FeatureIdentifier): void;
    disableExperimentalFeature(identifier: FeaturesImports.FeatureIdentifier): void;
    toggleExperimentalFeature(identifier: FeaturesImports.FeatureIdentifier): void;
    getExperimentalFeatures(): FeaturesImports.FeatureIdentifier[];
    isExperimentalFeature(featureId: FeaturesImports.FeatureIdentifier): boolean;
    getEnabledExperimentalFeatures(): FeaturesImports.FeatureIdentifier[];
    isExperimentalFeatureEnabled(featureId: FeaturesImports.FeatureIdentifier): boolean;
    setOfflineFeaturesCode(code: string): Promise<SetOfflineFeaturesFunctionResponse>;
    private getOfflineRepo;
    hasOfflineRepo(): boolean;
    deleteOfflineFeatureRepo(): Promise<void>;
    private parseOfflineEntitlementsCode;
    private downloadOfflineFeatures;
    migrateFeatureRepoToUserSetting(featureRepos?: Models.SNFeatureRepo[]): Promise<void>;
    migrateFeatureRepoToOfflineEntitlements(featureRepos?: Models.SNFeatureRepo[]): Promise<void>;
    initializeFromDisk(): void;
    updateRolesAndFetchFeatures(userUuid: UuidString, roles: RoleName[]): Promise<void>;
    private setRoles;
    didDownloadFeatures(features: FeaturesImports.FeatureDescription[]): Promise<void>;
    isThirdPartyFeature(identifier: string): boolean;
    private mapRemoteNativeFeatureToStaticFeature;
    getUserFeature(featureId: FeaturesImports.FeatureIdentifier): FeaturesImports.FeatureDescription | undefined;
    hasOnlineSubscription(): boolean;
    hasPaidOnlineOrOfflineSubscription(): boolean;
    rolesBySorting(roles: RoleName[]): RoleName[];
    hasMinimumRole(role: RoleName): boolean;
    isFeatureDeprecated(featureId: FeaturesImports.FeatureIdentifier): boolean;
    isFreeFeature(featureId: FeaturesImports.FeatureIdentifier): boolean;
    getFeatureStatus(featureId: FeaturesImports.FeatureIdentifier): FeatureStatus;
    private haveRolesChanged;
    private componentContentForNativeFeatureDescription;
    private mapRemoteNativeFeaturesToItems;
    private mapNativeFeatureToItem;
    downloadExternalFeature(urlOrCode: string): Promise<Models.SNComponent | undefined>;
    private performDownloadExternalFeature;
    deinit(): void;
    getDiagnostics(): Promise<DiagnosticInfo | undefined>;
}
