import { ChallengeValidation, ChallengeReason, ChallengeInterface, ChallengePrompt } from '@standardnotes/services';
/**
 * A challenge is a stateless description of what the client needs to provide
 * in order to proceed.
 */
export declare class Challenge implements ChallengeInterface {
    readonly prompts: ChallengePrompt[];
    readonly reason: ChallengeReason;
    readonly cancelable: boolean;
    readonly _heading?: string | undefined;
    readonly _subheading?: string | undefined;
    readonly id: number;
    constructor(prompts: ChallengePrompt[], reason: ChallengeReason, cancelable: boolean, _heading?: string | undefined, _subheading?: string | undefined);
    /** Outside of the modal, this is the title of the modal itself */
    get modalTitle(): string;
    /** Inside of the modal, this is the H1 */
    get heading(): string | undefined;
    /** Inside of the modal, this is the H2 */
    get subheading(): string | undefined;
    hasPromptForValidationType(type: ChallengeValidation): boolean;
}
