import { UserRolesChangedEvent } from '@standardnotes/domain-events';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
import { WebSocketApiServiceInterface } from '@standardnotes/api';
import { DiskStorageService } from '../Storage/DiskStorageService';
export declare enum WebSocketsServiceEvent {
    UserRoleMessageReceived = "WebSocketMessageReceived"
}
export declare class SNWebSocketsService extends AbstractService<WebSocketsServiceEvent, UserRolesChangedEvent> {
    private storageService;
    private webSocketUrl;
    private webSocketApiService;
    protected internalEventBus: InternalEventBusInterface;
    private webSocket?;
    constructor(storageService: DiskStorageService, webSocketUrl: string | undefined, webSocketApiService: WebSocketApiServiceInterface, internalEventBus: InternalEventBusInterface);
    setWebSocketUrl(url: string | undefined): void;
    loadWebSocketUrl(): void;
    startWebSocketConnection(): Promise<void>;
    closeWebSocketConnection(): void;
    private onWebSocketMessage;
    private onWebSocketClose;
    private createWebSocketConnectionToken;
    deinit(): void;
}
