import { ProtocolVersion } from '@standardnotes/common';
export declare const API_MESSAGE_GENERIC_INVALID_LOGIN = "A server error occurred while trying to sign in. Please try again.";
export declare const API_MESSAGE_GENERIC_REGISTRATION_FAIL = "A server error occurred while trying to register. Please try again.";
export declare const API_MESSAGE_GENERIC_CHANGE_CREDENTIALS_FAIL = "Something went wrong while changing your credentials. Your credentials were not changed. Please try again.";
export declare const API_MESSAGE_GENERIC_SYNC_FAIL = "Could not connect to server.";
export declare const ServerErrorStrings: {
    DeleteAccountError: string;
};
export declare const API_MESSAGE_GENERIC_INTEGRITY_CHECK_FAIL = "Could not check your data integrity with the server.";
export declare const API_MESSAGE_GENERIC_SINGLE_ITEM_SYNC_FAIL = "Could not retrieve item.";
export declare const API_MESSAGE_REGISTRATION_IN_PROGRESS = "An existing registration request is already in progress.";
export declare const API_MESSAGE_LOGIN_IN_PROGRESS = "An existing sign in request is already in progress.";
export declare const API_MESSAGE_CHANGE_CREDENTIALS_IN_PROGRESS = "An existing change credentials request is already in progress.";
export declare const API_MESSAGE_FALLBACK_LOGIN_FAIL = "Invalid email or password.";
export declare const API_MESSAGE_GENERIC_TOKEN_REFRESH_FAIL = "A server error occurred while trying to refresh your session. Please try again.";
export declare const API_MESSAGE_TOKEN_REFRESH_IN_PROGRESS = "Your account session is being renewed with the server. Please try your request again.";
export declare const API_MESSAGE_RATE_LIMITED = "Too many successive server requests. Please wait a few minutes and try again.";
export declare const API_MESSAGE_INVALID_SESSION = "Please sign in to an account in order to continue with your request.";
export declare const API_MESSAGE_FAILED_GET_SETTINGS = "Failed to get settings.";
export declare const API_MESSAGE_FAILED_UPDATE_SETTINGS = "Failed to update settings.";
export declare const API_MESSAGE_FAILED_LISTED_REGISTRATION = "Unable to register for Listed. Please try again later.";
export declare const API_MESSAGE_FAILED_CREATE_FILE_TOKEN = "Failed to create file token.";
export declare const API_MESSAGE_FAILED_SUBSCRIPTION_INFO = "Failed to get subscription's information.";
export declare const API_MESSAGE_FAILED_ACCESS_PURCHASE = "Failed to access purchase flow.";
export declare const API_MESSAGE_FAILED_DELETE_REVISION = "Failed to delete revision.";
export declare const API_MESSAGE_FAILED_OFFLINE_FEATURES = "Failed to get offline features.";
export declare const API_MESSAGE_UNTRUSTED_EXTENSIONS_WARNING = "The extension you are attempting to install comes from an\n  untrusted source. Untrusted extensions may lower the security of your data. Do you want to continue?";
export declare const API_MESSAGE_FAILED_DOWNLOADING_EXTENSION = "Error downloading package details. Please check the\n  extension link and try again.";
export declare const API_MESSAGE_FAILED_OFFLINE_ACTIVATION = "An unknown issue occurred during offline activation. Please try again.";
export declare const INVALID_EXTENSION_URL = "Invalid extension URL.";
export declare const UNSUPPORTED_PROTOCOL_VERSION = "This version of the application does not support your newer account type. Please upgrade to the latest version of Standard Notes to sign in.";
export declare const EXPIRED_PROTOCOL_VERSION = "The protocol version associated with your account is outdated and no longer supported by this application. Please visit standardnotes.com/help/security for more information.";
export declare const UNSUPPORTED_KEY_DERIVATION = "Your account was created on a platform with higher security capabilities than this browser supports. If we attempted to generate your login keys here, it would take hours. Please use a browser with more up to date security capabilities, like Google Chrome or Firefox, to log in.";
export declare const INVALID_PASSWORD_COST = "Unable to sign in due to insecure password parameters. Please visit standardnotes.com/help/security for more information.";
export declare const INVALID_PASSWORD = "Invalid password.";
export declare const OUTDATED_PROTOCOL_ALERT_IGNORE = "Sign In";
export declare const UPGRADING_ENCRYPTION = "Upgrading your account's encryption version\u2026";
export declare const SETTING_PASSCODE = "Setting passcode\u2026";
export declare const CHANGING_PASSCODE = "Changing passcode\u2026";
export declare const REMOVING_PASSCODE = "Removing passcode\u2026";
export declare const DO_NOT_CLOSE_APPLICATION = "Do not close the application until this process completes.";
export declare const UNKNOWN_ERROR = "Unknown error.";
export declare function InsufficientPasswordMessage(minimum: number): string;
export declare function StrictSignInFailed(current: ProtocolVersion, latest: ProtocolVersion): string;
export declare const CredentialsChangeStrings: {
    PasscodeRequired: string;
    Failed: string;
};
export declare const RegisterStrings: {
    PasscodeRequired: string;
};
export declare const SignInStrings: {
    PasscodeRequired: string;
    IncorrectMfa: string;
    SignInCanceledMissingMfa: string;
};
export declare const ProtocolUpgradeStrings: {
    SuccessAccount: string;
    SuccessPasscodeOnly: string;
    Fail: string;
    UpgradingPasscode: string;
};
export declare const ChallengeModalTitle: {
    Generic: string;
    Migration: string;
};
export declare const SessionStrings: {
    EnterEmailAndPassword: string;
    RecoverSession(email?: string): string;
    SessionRestored: string;
    EnterMfa: string;
    MfaInputPlaceholder: string;
    EmailInputPlaceholder: string;
    PasswordInputPlaceholder: string;
    KeychainRecoveryErrorTitle: string;
    KeychainRecoveryError: string;
    RevokeTitle: string;
    RevokeConfirmButton: string;
    RevokeCancelButton: string;
    RevokeText: string;
    CurrentSessionRevoked: string;
};
export declare const ChallengeStrings: {
    UnlockApplication: string;
    NoteAccess: string;
    FileAccess: string;
    ImportFile: string;
    AddPasscode: string;
    RemovePasscode: string;
    ChangePasscode: string;
    ChangeAutolockInterval: string;
    RevokeSession: string;
    EnterAccountPassword: string;
    EnterLocalPasscode: string;
    EnterPasscodeForMigration: string;
    EnterPasscodeForRootResave: string;
    EnterCredentialsForProtocolUpgrade: string;
    EnterCredentialsForDecryptedBackupDownload: string;
    AccountPasswordPlaceholder: string;
    LocalPasscodePlaceholder: string;
    DecryptEncryptedFile: string;
    ExportBackup: string;
    DisableBiometrics: string;
    UnprotectNote: string;
    UnprotectFile: string;
    SearchProtectedNotesText: string;
    SelectProtectedNote: string;
    DisableMfa: string;
    DeleteAccount: string;
};
export declare const ErrorAlertStrings: {
    MissingSessionTitle: string;
    MissingSessionBody: string;
    StorageDecryptErrorTitle: string;
    StorageDecryptErrorBody: string;
};
export declare const KeychainRecoveryStrings: {
    Title: string;
    Text: string;
};
