import { HttpResponse } from '@standardnotes/responses';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
import { Environment } from '@standardnotes/models';
export declare enum HttpVerb {
    Get = "GET",
    Post = "POST",
    Put = "PUT",
    Patch = "PATCH",
    Delete = "DELETE"
}
export declare type HttpParams = Record<string, unknown>;
export declare type HttpRequest = {
    url: string;
    params?: HttpParams;
    rawBytes?: Uint8Array;
    verb: HttpVerb;
    authentication?: string;
    customHeaders?: Record<string, string>[];
    responseType?: XMLHttpRequestResponseType;
    external?: boolean;
};
/**
 * A non-SNJS specific wrapper for XMLHttpRequests
 */
export declare class SNHttpService extends AbstractService {
    private readonly environment;
    private readonly appVersion;
    protected internalEventBus: InternalEventBusInterface;
    constructor(environment: Environment, appVersion: string, internalEventBus: InternalEventBusInterface);
    getAbsolute(url: string, params?: HttpParams, authentication?: string): Promise<HttpResponse>;
    postAbsolute(url: string, params?: HttpParams, authentication?: string): Promise<HttpResponse>;
    putAbsolute(url: string, params?: HttpParams, authentication?: string): Promise<HttpResponse>;
    patchAbsolute(url: string, params: HttpParams, authentication?: string): Promise<HttpResponse>;
    deleteAbsolute(url: string, params?: HttpParams, authentication?: string): Promise<HttpResponse>;
    runHttp(httpRequest: HttpRequest): Promise<HttpResponse>;
    private createRequestBody;
    private createXmlRequest;
    private runRequest;
    private stateChangeHandlerForRequest;
    private urlForUrlAndParams;
}
