import { AbstractService, AppGroupManagedApplication, DeinitCallback, DeviceInterface, InternalEventBusInterface } from '@standardnotes/services';
import { AppGroupCallback } from './AppGroupCallback';
import { ApplicationGroupEvent, ApplicationGroupEventData } from './ApplicationGroupEvent';
import { ApplicationDescriptor } from './ApplicationDescriptor';
export declare class SNApplicationGroup<D extends DeviceInterface = DeviceInterface> extends AbstractService<ApplicationGroupEvent, ApplicationGroupEventData[ApplicationGroupEvent.PrimaryApplicationSet] | ApplicationGroupEventData[ApplicationGroupEvent.DeviceWillRestart] | ApplicationGroupEventData[ApplicationGroupEvent.DescriptorsDataChanged]> {
    device: D;
    primaryApplication: AppGroupManagedApplication;
    private descriptorRecord;
    callback: AppGroupCallback<D>;
    constructor(device: D, internalEventBus?: InternalEventBusInterface);
    deinit(): void;
    initialize(callback: AppGroupCallback<D>): Promise<void>;
    private createNewDescriptorRecord;
    getDescriptors(): ApplicationDescriptor[];
    private findPrimaryDescriptor;
    signOutAllWorkspaces(): Promise<void>;
    onApplicationDeinit: DeinitCallback;
    setDescriptorAsPrimary(primaryDescriptor: ApplicationDescriptor): void;
    private persistDescriptors;
    renameDescriptor(descriptor: ApplicationDescriptor, label: string): void;
    removeDescriptor(descriptor: ApplicationDescriptor): Promise<void>;
    removeAllDescriptors(): Promise<void>;
    private descriptorForApplication;
    private createNewApplicationDescriptor;
    private createNewPrimaryDescriptor;
    unloadCurrentAndCreateNewDescriptor(label?: string): Promise<void>;
    unloadCurrentAndActivateDescriptor(descriptor: ApplicationDescriptor): Promise<void>;
    private buildApplication;
}
