import { UserRegistrationResponseBody } from '@standardnotes/api';
import * as Common from '@standardnotes/common';
import * as ExternalServices from '@standardnotes/services';
import * as Models from '@standardnotes/models';
import * as Responses from '@standardnotes/responses';
import * as InternalServices from '../Services';
import * as Settings from '@standardnotes/settings';
import { Subscription } from '@standardnotes/security';
import { UuidString } from '../Types';
import { ApplicationEvent, ApplicationEventCallback, ComponentManagerInterface, DiagnosticInfo, ChallengeValue, ChallengeReason, DeinitMode, DeinitSource, AppGroupManagedApplication, ApplicationInterface, EncryptionService, FilesBackupService } from '@standardnotes/services';
import { FilesClientInterface } from '@standardnotes/files';
import { BackupFile, DecryptedItemInterface, EncryptedItemInterface, Environment, ItemStream, Platform } from '@standardnotes/models';
import { ClientDisplayableError } from '@standardnotes/responses';
import { Challenge, ChallengeResponse } from '../Services';
import { ApplicationConstructorOptions, FullyResolvedApplicationOptions } from './Options/ApplicationOptions';
declare type LaunchCallback = {
    receiveChallenge: (challenge: Challenge) => void;
};
export declare class SNApplication implements ApplicationInterface, AppGroupManagedApplication, InternalServices.ListedClientInterface {
    onDeinit: ExternalServices.DeinitCallback;
    /**
     * A runtime based identifier for each dynamic instantiation of the application instance.
     * This differs from the persistent application.identifier which persists in storage
     * across instantiations.
     */
    readonly ephemeralIdentifier: string;
    private migrationService;
    /**
     * @deprecated will be fully replaced by @standardnotes/api::HttpService
     */
    private deprecatedHttpService;
    private httpService;
    private payloadManager;
    protocolService: EncryptionService;
    private diskStorageService;
    private inMemoryStore;
    /**
     * @deprecated will be fully replaced by @standardnotes/api services
     */
    private apiService;
    private userApiService;
    private userServer;
    private subscriptionApiService;
    private subscriptionServer;
    private subscriptionManager;
    private workspaceApiService;
    private workspaceServer;
    private workspaceManager;
    private webSocketApiService;
    private webSocketServer;
    private sessionManager;
    private syncService;
    private challengeService;
    singletonManager: InternalServices.SNSingletonManager;
    componentManagerService: InternalServices.SNComponentManager;
    protectionService: InternalServices.SNProtectionService;
    actionsManager: InternalServices.SNActionsService;
    historyManager: InternalServices.SNHistoryManager;
    private itemManager;
    private keyRecoveryService;
    private preferencesService;
    private featuresService;
    private userService;
    private webSocketsService;
    private settingsService;
    private mfaService;
    private listedService;
    private fileService;
    private mutatorService;
    private integrityService;
    private statusService;
    private filesBackupService?;
    private internalEventBus;
    private eventHandlers;
    private services;
    private streamRemovers;
    private serviceObservers;
    private managedSubscribers;
    private autoSyncInterval;
    /** True if the result of deviceInterface.openDatabase yields a new database being created */
    private createdNewDatabase;
    /** True if the application has started (but not necessarily launched) */
    private started;
    /** True if the application has launched */
    private launched;
    /** Whether the application has been destroyed via .deinit() */
    dealloced: boolean;
    private revokingSession;
    private handledFullSyncStage;
    readonly environment: Environment;
    readonly platform: Platform;
    deviceInterface: ExternalServices.DeviceInterface;
    alertService: ExternalServices.AlertService;
    readonly identifier: Common.ApplicationIdentifier;
    readonly options: FullyResolvedApplicationOptions;
    constructor(options: ApplicationConstructorOptions);
    get subscriptions(): ExternalServices.SubscriptionClientInterface;
    get workspaces(): ExternalServices.WorkspaceClientInterface;
    get files(): FilesClientInterface;
    get features(): ExternalServices.FeaturesClientInterface;
    get items(): ExternalServices.ItemsClientInterface;
    get protections(): InternalServices.ProtectionsClientInterface;
    get sync(): InternalServices.SyncClientInterface;
    get user(): ExternalServices.UserClientInterface;
    get settings(): InternalServices.SNSettingsService;
    get mutator(): ExternalServices.MutatorClientInterface;
    get sessions(): InternalServices.SessionsClientInterface;
    get status(): ExternalServices.StatusServiceInterface;
    get fileBackups(): FilesBackupService | undefined;
    get componentManager(): ComponentManagerInterface;
    computePrivateUsername(username: string): Promise<string | undefined>;
    /**
     * The first thing consumers should call when starting their app.
     * This function will load all services in their correct order.
     */
    prepareForLaunch(callback: LaunchCallback): Promise<void>;
    private setLaunchCallback;
    /**
     * Handles device authentication, unlocks application, and
     * issues a callback if a device activation requires user input
     * (i.e local passcode or fingerprint).
     * @param awaitDatabaseLoad
     * Option to await database load before marking the app as ready.
     */
    launch(awaitDatabaseLoad?: boolean): Promise<void>;
    onStart(): void;
    onLaunch(): void;
    getLaunchChallenge(): Challenge | undefined;
    private handleLaunchChallengeResponse;
    private beginAutoSyncTimer;
    private handleStage;
    /**
     * @param singleEvent Whether to only listen for a particular event.
     */
    addEventObserver(callback: ApplicationEventCallback, singleEvent?: ApplicationEvent): () => void;
    addSingleEventObserver(event: ApplicationEvent, callback: ApplicationEventCallback): () => void;
    getDiagnostics(): Promise<DiagnosticInfo>;
    private notifyEvent;
    /**
     * Whether the local database has completed loading local items.
     */
    isDatabaseLoaded(): boolean;
    getSessions(): Promise<(Responses.HttpResponse & {
        data: InternalServices.RemoteSession[];
    }) | Responses.HttpResponse>;
    revokeSession(sessionId: UuidString): Promise<Responses.HttpResponse | undefined>;
    /**
     * Revokes all sessions except the current one.
     */
    revokeAllOtherSessions(): Promise<void>;
    userCanManageSessions(): boolean;
    getUserSubscription(): Promise<Subscription | Responses.ClientDisplayableError>;
    getAvailableSubscriptions(): Promise<Responses.AvailableSubscriptions | Responses.ClientDisplayableError>;
    /**
     * Begin streaming items to display in the UI. The stream callback will be called
     * immediately with the present items that match the constraint, and over time whenever
     * items matching the constraint are added, changed, or deleted.
     */
    streamItems<I extends DecryptedItemInterface = DecryptedItemInterface>(contentType: Common.ContentType | Common.ContentType[], stream: ItemStream<I>): () => void;
    /**
     * Set the server's URL
     */
    setHost(host: string): Promise<void>;
    getHost(): string | undefined;
    setCustomHost(host: string): Promise<void>;
    getUser(): Responses.User | undefined;
    getUserPasswordCreationDate(): Date | undefined;
    getProtocolEncryptionDisplayName(): Promise<string | undefined>;
    getUserVersion(): Common.ProtocolVersion | undefined;
    /**
     * Returns true if there is an upgrade available for the account or passcode
     */
    protocolUpgradeAvailable(): Promise<boolean>;
    /**
     * Returns true if there is an encryption source available
     */
    isEncryptionAvailable(): boolean;
    upgradeProtocolVersion(): Promise<{
        success?: true;
        canceled?: true;
        error?: {
            message: string;
        };
    }>;
    noAccount(): boolean;
    hasAccount(): boolean;
    /**
     * @returns true if the user has a source of protection available, such as a
     * passcode, password, or biometrics.
     */
    hasProtectionSources(): boolean;
    hasUnprotectedAccessSession(): boolean;
    /**
     * When a user specifies a non-zero remember duration on a protection
     * challenge, a session will be started during which protections are disabled.
     */
    getProtectionSessionExpiryDate(): Date;
    clearProtectionSession(): Promise<void>;
    authorizeProtectedActionForNotes(notes: Models.SNNote[], challengeReason: ChallengeReason): Promise<Models.SNNote[]>;
    /**
     * @returns whether note access has been granted or not
     */
    authorizeNoteAccess(note: Models.SNNote): Promise<boolean>;
    authorizeAutolockIntervalChange(): Promise<boolean>;
    authorizeSearchingProtectedNotesText(): Promise<boolean>;
    canRegisterNewListedAccount(): boolean;
    requestNewListedAccount(): Promise<Responses.ListedAccount | undefined>;
    getListedAccounts(): Promise<Responses.ListedAccount[]>;
    getListedAccountInfo(account: Responses.ListedAccount, inContextOfItem?: UuidString): Promise<Responses.ListedAccountInfo | undefined>;
    createEncryptedBackupFileForAutomatedDesktopBackups(): Promise<BackupFile | undefined>;
    createEncryptedBackupFile(): Promise<BackupFile | undefined>;
    createDecryptedBackupFile(): Promise<BackupFile | undefined>;
    isEphemeralSession(): boolean;
    setValue(key: string, value: unknown, mode?: ExternalServices.StorageValueModes): void;
    getValue(key: string, mode?: ExternalServices.StorageValueModes): unknown;
    removeValue(key: string, mode?: ExternalServices.StorageValueModes): Promise<void>;
    getPreference<K extends Models.PrefKey>(key: K): Models.PrefValue[K] | undefined;
    getPreference<K extends Models.PrefKey>(key: K, defaultValue: Models.PrefValue[K]): Models.PrefValue[K];
    setPreference<K extends Models.PrefKey>(key: K, value: Models.PrefValue[K]): Promise<void>;
    /**
     * Gives services a chance to complete any sensitive operations before yielding
     * @param maxWait The maximum number of milliseconds to wait for services
     * to finish tasks. 0 means no limit.
     */
    private prepareForDeinit;
    promptForCustomChallenge(challenge: Challenge): Promise<ChallengeResponse | undefined>;
    addChallengeObserver(challenge: Challenge, observer: InternalServices.ChallengeObserver): () => void;
    submitValuesForChallenge(challenge: Challenge, values: ChallengeValue[]): Promise<void>;
    cancelChallenge(challenge: Challenge): void;
    setOnDeinit(onDeinit: ExternalServices.DeinitCallback): void;
    /**
     * Destroys the application instance.
     */
    deinit(mode: DeinitMode, source: DeinitSource): void;
    /**
     *  @param mergeLocal  Whether to merge existing offline data into account. If false,
     *                     any pre-existing data will be fully deleted upon success.
     */
    register(email: string, password: string, ephemeral?: boolean, mergeLocal?: boolean): Promise<UserRegistrationResponseBody>;
    /**
     * @param mergeLocal  Whether to merge existing offline data into account.
     * If false, any pre-existing data will be fully deleted upon success.
     */
    signIn(email: string, password: string, strict?: boolean, ephemeral?: boolean, mergeLocal?: boolean, awaitSync?: boolean): Promise<Responses.HttpResponse | Responses.SignInResponse>;
    changeEmail(newEmail: string, currentPassword: string, passcode?: string, origination?: Common.KeyParamsOrigination): Promise<InternalServices.CredentialsChangeFunctionResponse>;
    changePassword(currentPassword: string, newPassword: string, passcode?: string, origination?: Common.KeyParamsOrigination, validateNewPasswordStrength?: boolean): Promise<InternalServices.CredentialsChangeFunctionResponse>;
    private handleRevokedSession;
    validateAccountPassword(password: string): Promise<boolean>;
    isStarted(): boolean;
    isLaunched(): boolean;
    hasPasscode(): boolean;
    isLocked(): Promise<boolean>;
    lock(): Promise<void>;
    softLockBiometrics(): void;
    isNativeMobileWeb(): boolean;
    getDeinitMode(): DeinitMode;
    addPasscode(passcode: string): Promise<boolean>;
    /**
     * @returns whether the passcode was successfuly removed
     */
    removePasscode(): Promise<boolean>;
    changePasscode(newPasscode: string, origination?: Common.KeyParamsOrigination): Promise<boolean>;
    getStorageEncryptionPolicy(): ExternalServices.StorageEncryptionPolicy;
    setStorageEncryptionPolicy(encryptionPolicy: ExternalServices.StorageEncryptionPolicy): Promise<void>;
    enableEphemeralPersistencePolicy(): Promise<void>;
    hasPendingMigrations(): Promise<boolean>;
    generateUuid(): string;
    presentKeyRecoveryWizard(): void;
    canAttemptDecryptionOfItem(item: EncryptedItemInterface): ClientDisplayableError | true;
    /**
     * Dynamically change the device interface, i.e when Desktop wants to override
     * default web interface.
     */
    changeDeviceInterface(deviceInterface: ExternalServices.DeviceInterface): void;
    isMfaFeatureAvailable(): boolean;
    isMfaActivated(): Promise<boolean>;
    generateMfaSecret(): Promise<string>;
    getOtpToken(secret: string): Promise<string>;
    enableMfa(secret: string, otpToken: string): Promise<void>;
    disableMfa(): Promise<void>;
    getNewSubscriptionToken(): Promise<string | undefined>;
    isThirdPartyHostUsed(): boolean;
    getCloudProviderIntegrationUrl(cloudProviderName: Settings.CloudProvider, isDevEnvironment: boolean): string;
    private constructServices;
    private clearServices;
    private constructInternalEventBus;
    private defineInternalEventHandlers;
    private clearInternalEventBus;
    private createListedService;
    private createFileService;
    private createIntegrityService;
    private createFeaturesService;
    private createWebSocketsService;
    private createMigrationService;
    private createUserService;
    private createApiService;
    private createUserApiService;
    private createUserServer;
    private createSubscriptionApiService;
    private createSubscriptionServer;
    private createWebSocketApiService;
    private createWebSocketServer;
    private createSubscriptionManager;
    private createWorkspaceServer;
    private createWorkspaceApiService;
    private createWorkspaceManager;
    private createItemManager;
    private createComponentManager;
    private createHttpManager;
    private createHttpService;
    private createPayloadManager;
    private createSingletonManager;
    private createDiskStorageManager;
    private createInMemoryStorageManager;
    private createProtocolService;
    private createKeyRecoveryService;
    private createSessionManager;
    private createSyncManager;
    private createChallengeService;
    private createProtectionService;
    private createHistoryManager;
    private createActionsManager;
    private createPreferencesService;
    private createSettingsService;
    private createMfaService;
    private createMutatorService;
    private createFilesBackupService;
    private createStatusService;
    private getClass;
}
export {};
