import { ItemManager } from '../Items/ItemManager';
import { PayloadManager } from '../Payloads/PayloadManager';
import { SNApiService } from '../Api/ApiService';
import { SNHistoryManager } from '../History/HistoryManager';
import { SNSessionManager } from '../Session/SessionManager';
import { DiskStorageService } from '../Storage/DiskStorageService';
import { SyncClientInterface } from './SyncClientInterface';
import { SyncOpStatus } from './SyncOpStatus';
import { ServerSyncResponse } from './Account/Response';
import { FullyFormedTransferPayload, FullyFormedPayloadInterface } from '@standardnotes/models';
import { AbstractService, SyncEvent, SyncSource, InternalEventHandlerInterface, InternalEventBusInterface, InternalEventInterface, SyncOptions, SyncServiceInterface, DiagnosticInfo, EncryptionService } from '@standardnotes/services';
import { OfflineSyncResponse } from './Offline/Response';
import { ApplicationSyncOptions } from '../../Application/Options/OptionalOptions';
/**
 * The sync service orchestrates with the model manager, api service, and storage service
 * to ensure consistent state between the three. When a change is made to an item, consumers
 * call the sync service's sync function to first persist pending changes to local storage.
 * Then, the items are uploaded to the server. The sync service handles server responses,
 * including mapping any retrieved items to application state via model manager mapping.
 * After each sync request, any changes made or retrieved are also persisted locally.
 * The sync service largely does not perform any task unless it is called upon.
 */
export declare class SNSyncService extends AbstractService<SyncEvent, ServerSyncResponse | OfflineSyncResponse | {
    source: SyncSource;
}> implements SyncServiceInterface, InternalEventHandlerInterface, SyncClientInterface {
    private itemManager;
    private sessionManager;
    private protocolService;
    private storageService;
    private payloadManager;
    private apiService;
    private historyService;
    private readonly options;
    protected internalEventBus: InternalEventBusInterface;
    private dirtyIndexAtLastPresyncSave?;
    private lastSyncDate?;
    private outOfSync;
    private opStatus;
    private resolveQueue;
    private spawnQueue;
    completedOnlineDownloadFirstSync: boolean;
    private majorChangeThreshold;
    private clientLocked;
    private databaseLoaded;
    private syncToken?;
    private cursorToken?;
    private syncLock;
    private _simulate_latency?;
    private dealloced;
    lastSyncInvokationPromise?: Promise<unknown>;
    currentSyncRequestPromise?: Promise<void>;
    /** Content types appearing first are always mapped first */
    private readonly localLoadPriorty;
    constructor(itemManager: ItemManager, sessionManager: SNSessionManager, protocolService: EncryptionService, storageService: DiskStorageService, payloadManager: PayloadManager, apiService: SNApiService, historyService: SNHistoryManager, options: ApplicationSyncOptions, internalEventBus: InternalEventBusInterface);
    /**
     * If the database has been newly created (because its new or was previously destroyed)
     * we want to reset any sync tokens we have.
     */
    onNewDatabaseCreated(): Promise<void>;
    private get launchPriorityUuids();
    setLaunchPriorityUuids(launchPriorityUuids: string[]): void;
    deinit(): void;
    private initializeStatus;
    lockSyncing(): void;
    unlockSyncing(): void;
    isOutOfSync(): boolean;
    getLastSyncDate(): Date | undefined;
    getSyncStatus(): SyncOpStatus;
    /**
     * Called by application when sign in or registration occurs.
     */
    resetSyncState(): void;
    isDatabaseLoaded(): boolean;
    /**
     * Used in tandem with `loadDatabasePayloads`
     */
    getDatabasePayloads(): Promise<FullyFormedTransferPayload[]>;
    private processItemsKeysFirstDuringDatabaseLoad;
    /**
     * @param rawPayloads - use `getDatabasePayloads` to get these payloads.
     * They are fed as a parameter so that callers don't have to await the loading, but can
     * await getting the raw payloads from storage
     */
    loadDatabasePayloads(rawPayloads: FullyFormedTransferPayload[]): Promise<void>;
    private processPayloadBatch;
    private setLastSyncToken;
    private setPaginationToken;
    private getLastSyncToken;
    private getPaginationToken;
    private clearSyncPositionTokens;
    private itemsNeedingSync;
    markAllItemsAsNeedingSyncAndPersist(): Promise<void>;
    /**
     * Return the payloads that need local persistence, before beginning a sync.
     * This way, if the application is closed before a sync request completes,
     * pending data will be saved to disk, and synced the next time the app opens.
     */
    private popPayloadsNeedingPreSyncSave;
    private queueStrategyResolveOnNext;
    private queueStrategyForceSpawnNew;
    /**
     * For timing strategy SyncQueueStrategy.ForceSpawnNew, we will execute a whole sync request
     * and pop it from the queue.
     */
    private popSpawnQueue;
    private payloadsByPreparingForServer;
    downloadFirstSync(waitTimeOnFailureMs: number, otherSyncOptions?: Partial<SyncOptions>): Promise<void>;
    awaitCurrentSyncs(): Promise<void>;
    sync(options?: Partial<SyncOptions>): Promise<unknown>;
    private prepareForSync;
    /**
     * Allows us to lock this function from triggering duplicate network requests.
     * There are two types of locking checks:
     * 1. syncLocked(): If a call to sync() call has begun preparing to be sent to the server.
     *                  but not yet completed all the code below before reaching that point.
     *                  (before reaching opStatus.setDidBegin).
     * 2. syncOpInProgress: If a sync() call is in flight to the server.
     */
    private configureSyncLock;
    private deferSyncRequest;
    private prepareForSyncExecution;
    /**
     * The InTime resolve queue refers to any sync requests that were made while we still
     * have not sent out the current request. So, anything in the InTime resolve queue
     * will have made it "in time" to piggyback on the current request. Anything that comes
     * after InTime will schedule a new sync request.
     */
    private getPendingRequestsMadeInTimeToPiggyBackOnCurrentRequest;
    private getOfflineSyncParameters;
    private createOfflineSyncOperation;
    private getOnlineSyncParameters;
    private createServerSyncOperation;
    private createSyncOperation;
    private performSync;
    private handleOfflineResponse;
    private handleErrorServerResponse;
    private handleSuccessServerResponse;
    private processServerPayloads;
    private decryptServerItemsKeys;
    private decryptProcessedServerPayloads;
    private handleSyncOperationFinish;
    private handleDownloadFirstCompletionAndSyncAgain;
    private syncAgainByHandlingRequestsWaitingInResolveQueue;
    /**
     * As part of the just concluded sync operation, more items may have
     * been dirtied (like conflicts), and the caller may want to await the
     * full resolution of these items.
     */
    private syncAgainByHandlingNewDirtyItems;
    /**
     * For timing strategy SyncQueueStrategy.ResolveOnNext.
     * Execute any callbacks pulled before this sync request began.
     * Calling resolve on the callbacks should be the last thing we do in this function,
     * to simulate calling .sync as if it went through straight to the end without having
     * to be queued.
     */
    private resolvePendingSyncRequestsThatMadeItInTimeOfCurrentRequest;
    private potentiallySyncAgainAfterSyncCompletion;
    /**
     * Items that have never been synced and marked as deleted should be cleared
     * as dirty, mapped, then removed from storage.
     */
    private handleNeverSyncedDeleted;
    persistPayloads(payloads: FullyFormedPayloadInterface[]): Promise<void>;
    setInSync(isInSync: boolean): void;
    handleEvent(event: InternalEventInterface): Promise<void>;
    private handleIntegrityCheckEventResponse;
    private emitOutOfSyncRemotePayloads;
    getDiagnostics(): Promise<DiagnosticInfo | undefined>;
    /** @e2e_testing */
    ut_setDatabaseLoaded(loaded: boolean): void;
    /** @e2e_testing */
    ut_clearLastSyncDate(): void;
    /** @e2e_testing */
    ut_beginLatencySimulator(latency: number): void;
    /** @e2e_testing */
    ut_endLatencySimulator(): void;
}
