import { ServerSyncPushContextualPayload } from '@standardnotes/models';
import { ServerSyncResponse } from './Response';
import { ResponseSignalReceiver } from '../Signals';
import { SNApiService } from '../../Api/ApiService';
export declare const SyncUpDownLimit = 150;
/**
 * A long running operation that handles multiple roundtrips from a server,
 * emitting a stream of values that should be acted upon in real time.
 */
export declare class AccountSyncOperation {
    private payloads;
    private receiver;
    private lastSyncToken;
    private paginationToken;
    private apiService;
    readonly id: string;
    private pendingPayloads;
    private responses;
    /**
     * @param payloads   An array of payloads to send to the server
     * @param receiver   A function that receives callback multiple times during the operation
     */
    constructor(payloads: ServerSyncPushContextualPayload[], receiver: ResponseSignalReceiver<ServerSyncResponse>, lastSyncToken: string, paginationToken: string, apiService: SNApiService);
    /**
     * Read the payloads that have been saved, or are currently in flight.
     */
    get payloadsSavedOrSaving(): ServerSyncPushContextualPayload[];
    popPayloads(count: number): ServerSyncPushContextualPayload[];
    run(): Promise<void>;
    get done(): boolean;
    private get pendingUploadCount();
    private get totalUploadCount();
    private get upLimit();
    private get downLimit();
    get numberOfItemsInvolved(): number;
}
