import { PayloadManager } from './../Payloads/PayloadManager';
import { ContentType } from '@standardnotes/common';
import { ItemManager } from '../Items/ItemManager';
import { DecryptedItemInterface, ItemContent, PredicateInterface } from '@standardnotes/models';
import { SNSyncService } from '../Sync/SyncService';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
/**
 * The singleton manager allow consumers to ensure that only 1 item exists of a certain
 * predicate. For example, consumers may want to ensure that only one item of contentType
 * UserPreferences exist. The singleton manager allows consumers to do this via 2 methods:
 * 1. Consumers may use `findOrCreateContentTypeSingleton` to retrieve an item if it exists, or create
 *    it otherwise. While this method may serve most cases, it does not allow the consumer
 *    to subscribe to changes, such as if after this method is called, a UserPreferences object
 *    is downloaded from a remote source.
 * 2. Items can override isSingleton, singletonPredicate, and strategyWhenConflictingWithItem (optional)
 *    to automatically gain singleton resolution.
 */
export declare class SNSingletonManager extends AbstractService {
    private itemManager;
    private payloadManager;
    private syncService;
    protected internalEventBus: InternalEventBusInterface;
    private resolveQueue;
    private removeItemObserver;
    private removeSyncObserver;
    constructor(itemManager: ItemManager, payloadManager: PayloadManager, syncService: SNSyncService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    private popResolveQueue;
    /**
     * We only want to resolve singletons for items that are newly created (because this
     * is when items proliferate). However, we don't want to resolve immediately on creation,
     * but instead wait for the next full sync to complete. This is so that when you download
     * a singleton and create the object, but the items key for the item has not yet been
     * downloaded, the singleton will be errorDecrypting, and would be mishandled in the
     * overall singleton logic. By waiting for a full sync to complete, we can be sure that
     * all items keys have been downloaded.
     */
    private addObservers;
    private validItemsMatchingPredicate;
    private resolveSingletonsForItems;
    private handleStrategy;
    findSingleton<T extends DecryptedItemInterface>(contentType: ContentType, predicate: PredicateInterface<T>): T | undefined;
    findOrCreateContentTypeSingleton<C extends ItemContent = ItemContent, T extends DecryptedItemInterface<C> = DecryptedItemInterface<C>>(contentType: ContentType, createContent: ItemContent): Promise<T>;
}
