import { SNApiService } from '../Api/ApiService';
import { SNSessionManager } from '../Session/SessionManager';
import { CloudProvider, EmailBackupFrequency, SettingName, SensitiveSettingName, SubscriptionSettingName } from '@standardnotes/settings';
import { AbstractService, InternalEventBusInterface } from '@standardnotes/services';
import { SettingsClientInterface } from './SettingsClientInterface';
export declare class SNSettingsService extends AbstractService implements SettingsClientInterface {
    private readonly sessionManager;
    private readonly apiService;
    protected internalEventBus: InternalEventBusInterface;
    private provider;
    private frequencyOptionsLabels;
    private cloudProviderIntegrationUrlEndpoints;
    constructor(sessionManager: SNSessionManager, apiService: SNApiService, internalEventBus: InternalEventBusInterface);
    initializeFromDisk(): void;
    listSettings(): Promise<import("./SettingsList").SettingsList>;
    getSetting(name: SettingName): Promise<string | undefined>;
    getSubscriptionSetting(name: SubscriptionSettingName): Promise<string | undefined>;
    updateSetting(name: SettingName, payload: string, sensitive?: boolean): Promise<void>;
    getDoesSensitiveSettingExist(name: SensitiveSettingName): Promise<boolean>;
    deleteSetting(name: SettingName): Promise<void>;
    getEmailBackupFrequencyOptionLabel(frequency: EmailBackupFrequency): string;
    getCloudProviderIntegrationUrl(cloudProviderName: CloudProvider, isDevEnvironment: boolean): string;
    deinit(): void;
}
