import { Uuid } from '@standardnotes/common';
export declare type RawJwtPayload = {
    jwt?: string;
};
export declare type RawSessionPayload = {
    accessToken: string;
    refreshToken: string;
    accessExpiration: number;
    refreshExpiration: number;
    readonlyAccess: boolean;
};
export declare type RawStorageValue = RawJwtPayload | RawSessionPayload;
export declare type RemoteSession = {
    uuid: Uuid;
    updated_at: Date;
    device_info: string;
    current: boolean;
};
