import { SessionRenewalResponse } from '@standardnotes/responses';
import { Session } from './Session';
/** For protocol versions >= 004 */
export declare class TokenSession extends Session {
    accessToken: string;
    accessExpiration: number;
    refreshToken: string;
    refreshExpiration: number;
    private readonlyAccess;
    static FromApiResponse(response: SessionRenewalResponse): TokenSession;
    constructor(accessToken: string, accessExpiration: number, refreshToken: string, refreshExpiration: number, readonlyAccess: boolean);
    isReadOnly(): boolean;
    private getExpireAt;
    get authorizationValue(): string;
    canExpire(): boolean;
    isExpired(): boolean;
}
