import { ContentType } from '@standardnotes/common';
import { DecryptedPayloadInterface, DeletedPayloadInterface, DeltaEmit, EncryptedPayloadInterface, FullyFormedPayloadInterface, PayloadEmitSource } from '@standardnotes/models';
export declare type EmitQueue<P extends FullyFormedPayloadInterface> = QueueElement<P>[];
export declare type PayloadManagerChangeData = {
    /** The payloads are pre-existing but have been changed */
    changed: FullyFormedPayloadInterface[];
    /** The payloads have been newly inserted */
    inserted: FullyFormedPayloadInterface[];
    /** The payloads have been deleted from local state (and remote state if applicable) */
    discarded: DeletedPayloadInterface[];
    /** Payloads for which encrypted overwrite protection is enabled and enacted */
    ignored: EncryptedPayloadInterface[];
    /** Payloads which were previously error decrypting but now successfully decrypted */
    unerrored: DecryptedPayloadInterface[];
    source: PayloadEmitSource;
    sourceKey?: string;
};
export declare type PayloadsChangeObserverCallback = (data: PayloadManagerChangeData) => void;
export declare type PayloadsChangeObserver = {
    types: ContentType[];
    callback: PayloadsChangeObserverCallback;
    priority: number;
};
export declare type QueueElement<P extends FullyFormedPayloadInterface = FullyFormedPayloadInterface> = {
    emit: DeltaEmit;
    sourceKey?: string;
    resolve: (alteredPayloads: P[]) => void;
};
