import { ComponentArea, ComponentAction } from '@standardnotes/features';
import { ComponentMessage, ItemContent, MessageData } from '@standardnotes/models';
import { UuidString } from '../../Types/UuidString';
import { ContentType } from '@standardnotes/common';
export declare type OutgoingItemMessagePayload = {
    uuid: string;
    content_type: ContentType;
    created_at: Date;
    updated_at: Date;
    deleted?: boolean;
    content?: ItemContent;
    clientData?: Record<string, unknown>;
    /**
     * isMetadataUpdate implies that the extension should make reference of updated
     * metadata, but not update content values as they may be stale relative to what the
     * extension currently has.
     */
    isMetadataUpdate: boolean;
};
/**
 * Extensions allowed to batch stream AllowedBatchContentTypes
 */
export declare const AllowedBatchStreaming: readonly string[];
/**
 * Content types which are allowed to be managed/streamed in bulk by a component.
 */
export declare const AllowedBatchContentTypes: readonly ContentType[];
export declare type StreamObserver = {
    identifier: string;
    componentUuid: UuidString;
    area: ComponentArea;
    originalMessage: ComponentMessage;
    /** contentTypes is optional in the case of a context stream observer */
    contentTypes?: ContentType[];
};
export declare type MessageReplyData = {
    approved?: boolean;
    deleted?: boolean;
    error?: string;
    item?: OutgoingItemMessagePayload;
    items?: OutgoingItemMessagePayload[];
    themes?: string[];
};
export declare type StreamItemsMessageData = MessageData & {
    content_types: ContentType[];
};
export declare type DeleteItemsMessageData = MessageData & {
    items: OutgoingItemMessagePayload[];
};
export declare type MessageReply = {
    action: ComponentAction;
    original: ComponentMessage;
    data: MessageReplyData;
};
