import { SNPreferencesService } from '../Preferences/PreferencesService';
import { ComponentViewerInterface, ComponentViewerError, FeatureStatus, AlertService } from '@standardnotes/services';
import { SNFeaturesService } from '..';
import { ActionObserver, ComponentEventObserver, ComponentMessage, SNComponent, DecryptedItemInterface, DeletedItemInterface, EncryptedItemInterface, ItemContent, PayloadEmitSource, Environment, Platform } from '@standardnotes/models';
import { SNSyncService } from '../Sync/SyncService';
import { MessageReply } from './Types';
import { ComponentPermission } from '@standardnotes/features';
import { ItemManager } from '../Items/ItemManager';
import { UuidString } from '../../Types/UuidString';
declare type RunWithPermissionsCallback = (componentUuid: UuidString, requiredPermissions: ComponentPermission[], runFunction: () => void) => void;
declare type ComponentManagerFunctions = {
    runWithPermissions: RunWithPermissionsCallback;
    urlsForActiveThemes: () => string[];
};
export declare class ComponentViewer implements ComponentViewerInterface {
    readonly component: SNComponent;
    private itemManager;
    private syncService;
    private alertService;
    private preferencesSerivce;
    private environment;
    private platform;
    private componentManagerFunctions;
    readonly url?: string | undefined;
    private contextItemUuid?;
    private streamItems?;
    private streamContextItemOriginalMessage?;
    private streamItemsOriginalMessage?;
    private removeItemObserver;
    private loggingEnabled;
    identifier: string;
    private actionObservers;
    overrideContextItem?: DecryptedItemInterface;
    private featureStatus;
    private removeFeaturesObserver;
    private eventObservers;
    private dealloced;
    private window?;
    private hidden;
    private readonly;
    lockReadonly: boolean;
    sessionKey?: string;
    constructor(component: SNComponent, itemManager: ItemManager, syncService: SNSyncService, alertService: AlertService, preferencesSerivce: SNPreferencesService, featuresService: SNFeaturesService, environment: Environment, platform: Platform, componentManagerFunctions: ComponentManagerFunctions, url?: string | undefined, contextItemUuid?: string | undefined, actionObserver?: ActionObserver);
    get isDesktop(): boolean;
    get isMobile(): boolean;
    destroy(): void;
    private deinit;
    addEventObserver(observer: ComponentEventObserver): () => void;
    private notifyEventObservers;
    addActionObserver(observer: ActionObserver): () => void;
    setReadonly(readonly: boolean): void;
    get componentUuid(): string;
    getFeatureStatus(): FeatureStatus;
    private isOfflineRestricted;
    private isNativeFeature;
    private hasUrlError;
    shouldRender(): boolean;
    getError(): ComponentViewerError | undefined;
    private updateOurComponentRefFromChangedItems;
    handleChangesInItems(items: (DecryptedItemInterface | DeletedItemInterface | EncryptedItemInterface)[], source: PayloadEmitSource, sourceKey?: string): void;
    sendManyItemsThroughBridge(items: (DecryptedItemInterface | DeletedItemInterface)[]): void;
    sendContextItemThroughBridge(item: DecryptedItemInterface, source?: PayloadEmitSource): void;
    private log;
    private sendItemsInReply;
    private jsonForItem;
    contentForItem(item: DecryptedItemInterface): ItemContent | undefined;
    private replyToMessage;
    /**
     * @param essential If the message is non-essential, no alert will be shown
     *  if we can no longer find the window.
     */
    sendMessage(message: ComponentMessage | MessageReply, essential?: boolean): void;
    private responseItemsByRemovingPrivateProperties;
    getWindow(): Window | undefined;
    /** Called by client when the iframe is ready */
    setWindow(window: Window): void;
    postActiveThemes(): void;
    setHidden(hidden: boolean): void;
    handleMessage(message: ComponentMessage): void;
    handleStreamItemsMessage(message: ComponentMessage): void;
    handleStreamContextItemMessage(message: ComponentMessage): void;
    /**
     * Save items is capable of saving existing items, and also creating new ones
     * if they don't exist.
     */
    handleSaveItemsMessage(message: ComponentMessage): void;
    handleCreateItemsMessage(message: ComponentMessage): void;
    handleDeleteItemsMessage(message: ComponentMessage): void;
    handleSetComponentDataMessage(message: ComponentMessage): void;
    handleSetSizeEvent(message: ComponentMessage): void;
    getIframe(): HTMLIFrameElement | undefined;
}
export {};
