import { SNPreferencesService } from '../Preferences/PreferencesService';
import { SNFeaturesService } from '../Features/FeaturesService';
import { ItemManager } from '../Items/ItemManager';
import { ActionObserver, SNNote, SNTheme, SNComponent, PayloadEmitSource, PermissionDialog, Environment, Platform } from '@standardnotes/models';
import { SNSyncService } from '../Sync/SyncService';
import { ComponentArea, ComponentPermission, FeatureIdentifier } from '@standardnotes/features';
import { UuidString } from '../../Types/UuidString';
import { ComponentViewer } from './ComponentViewer';
import { AbstractService, ComponentManagerInterface, ComponentViewerInterface, DesktopManagerInterface, InternalEventBusInterface, AlertService, DeviceInterface } from '@standardnotes/services';
declare global {
    interface Window {
        /** IE Handlers */
        attachEvent(event: string, listener: EventListener): boolean;
        detachEvent(event: string, listener: EventListener): void;
    }
}
export declare enum ComponentManagerEvent {
    ViewerDidFocus = "ViewerDidFocus"
}
export declare type EventData = {
    componentViewer?: ComponentViewerInterface;
};
/**
 * Responsible for orchestrating component functionality, including editors, themes,
 * and other components. The component manager primarily deals with iframes, and orchestrates
 * sending and receiving messages to and from frames via the postMessage API.
 */
export declare class SNComponentManager extends AbstractService<ComponentManagerEvent, EventData> implements ComponentManagerInterface {
    private itemManager;
    private syncService;
    private featuresService;
    private preferencesSerivce;
    protected alertService: AlertService;
    private environment;
    private platform;
    protected internalEventBus: InternalEventBusInterface;
    private device;
    private desktopManager?;
    private viewers;
    private removeItemObserver;
    private permissionDialogs;
    constructor(itemManager: ItemManager, syncService: SNSyncService, featuresService: SNFeaturesService, preferencesSerivce: SNPreferencesService, alertService: AlertService, environment: Environment, platform: Platform, internalEventBus: InternalEventBusInterface, device: DeviceInterface);
    get isDesktop(): boolean;
    get isMobile(): boolean;
    get components(): SNComponent[];
    componentsForArea(area: ComponentArea): SNComponent[];
    componentWithIdentifier(identifier: FeatureIdentifier | string): SNComponent | undefined;
    deinit(): void;
    createComponentViewer(component: SNComponent, contextItem?: UuidString, actionObserver?: ActionObserver, urlOverride?: string): ComponentViewerInterface;
    destroyComponentViewer(viewer: ComponentViewerInterface): void;
    setDesktopManager(desktopManager: DesktopManagerInterface): void;
    handleChangedComponents(components: SNComponent[], source: PayloadEmitSource): void;
    addItemObserver(): void;
    detectFocusChange: () => void;
    onWindowMessage: (event: MessageEvent) => void;
    configureForDesktop(): void;
    postActiveThemesToAllViewers(): void;
    getActiveThemes(): SNTheme[];
    urlForComponent(component: SNComponent): string | undefined;
    urlsForActiveThemes(): string[];
    private findComponent;
    findComponentViewer(identifier: string): ComponentViewerInterface | undefined;
    componentViewerForSessionKey(key: string): ComponentViewerInterface | undefined;
    areRequestedPermissionsValid(component: SNComponent, permissions: ComponentPermission[]): boolean;
    runWithPermissions(componentUuid: UuidString, requiredPermissions: ComponentPermission[], runFunction: () => void): void;
    promptForPermissionsWithAngularAsyncRendering(component: SNComponent, permissions: ComponentPermission[], callback: (approved: boolean) => Promise<void>): void;
    promptForPermissions(component: SNComponent, permissions: ComponentPermission[], callback: (approved: boolean) => Promise<void>): void;
    presentPermissionsDialog(_dialog: PermissionDialog): void;
    toggleTheme(uuid: UuidString): Promise<void>;
    toggleComponent(uuid: UuidString): Promise<void>;
    isComponentActive(component: SNComponent): boolean;
    allComponentIframes(): HTMLIFrameElement[];
    iframeForComponentViewer(viewer: ComponentViewer): HTMLIFrameElement | undefined;
    editorForNote(note: SNNote): SNComponent | undefined;
    /**
     * Uses legacy approach of note/editor association. New method uses note.editorIdentifier and note.noteType directly.
     */
    private legacyGetEditorForNote;
    getDefaultEditor(): SNComponent | undefined;
    permissionsStringForPermissions(permissions: ComponentPermission[], component: SNComponent): string;
    doesEditorChangeRequireAlert(from: SNComponent | undefined, to: SNComponent | undefined): boolean;
    showEditorChangeAlert(): Promise<boolean>;
}
