import { SNPreferencesService } from '../Preferences/PreferencesService';
import { ComponentViewerInterface, ComponentViewerError, FeatureStatus, AlertService } from '@standardnotes/services';
import { SNFeaturesService } from '..';
import { ActionObserver, ComponentEventObserver, ComponentMessage, SNComponent, DecryptedItemInterface, DeletedItemInterface, EncryptedItemInterface, PayloadEmitSource, Environment, Platform, NoteBlock } from '@standardnotes/models';
import { SNSyncService } from '../Sync/SyncService';
import { MessageReply } from './Types';
import { ComponentPermission } from '@standardnotes/features';
import { ItemManager } from '../Items/ItemManager';
import { UuidString } from '../../Types/UuidString';
declare type RunWithPermissionsCallback = (componentUuid: UuidString, requiredPermissions: ComponentPermission[], runFunction: () => void) => void;
declare type ComponentManagerFunctions = {
    runWithPermissions: RunWithPermissionsCallback;
    urlsForActiveThemes: () => string[];
};
export declare class BlocksComponentViewer implements ComponentViewerInterface {
    readonly component: SNComponent;
    private noteUuid;
    private blockId;
    private itemManager;
    private syncService;
    private alertService;
    private preferencesSerivce;
    private environment;
    private platform;
    private componentManagerFunctions;
    readonly url?: string | undefined;
    private streamContextItemOriginalMessage?;
    private removeItemObserver;
    private loggingEnabled;
    identifier: string;
    private actionObservers;
    private featureStatus;
    private removeFeaturesObserver;
    private eventObservers;
    private dealloced;
    private window?;
    private readonly;
    lockReadonly: boolean;
    sessionKey?: string;
    private note;
    private lastBlockSent?;
    constructor(component: SNComponent, noteUuid: UuidString, blockId: NoteBlock['id'], itemManager: ItemManager, syncService: SNSyncService, alertService: AlertService, preferencesSerivce: SNPreferencesService, featuresService: SNFeaturesService, environment: Environment, platform: Platform, componentManagerFunctions: ComponentManagerFunctions, url?: string | undefined, actionObserver?: ActionObserver);
    get isDesktop(): boolean;
    get isMobile(): boolean;
    destroy(): void;
    private deinit;
    addEventObserver(observer: ComponentEventObserver): () => void;
    private notifyEventObservers;
    addActionObserver(observer: ActionObserver): () => void;
    setReadonly(readonly: boolean): void;
    get componentUuid(): string;
    getFeatureStatus(): FeatureStatus;
    private isOfflineRestricted;
    private isNativeFeature;
    private hasUrlError;
    shouldRender(): boolean;
    getError(): ComponentViewerError | undefined;
    private updateOurComponentRefFromChangedItems;
    handleChangesInGlobalItems(items: (DecryptedItemInterface | DeletedItemInterface | EncryptedItemInterface)[], source: PayloadEmitSource, sourceKey?: string): void;
    sendNoteToEditor(source?: PayloadEmitSource): void;
    private log;
    private replyToMessage;
    /**
     * @param essential If the message is non-essential, no alert will be shown
     *  if we can no longer find the window.
     */
    sendMessage(message: ComponentMessage | MessageReply, essential?: boolean): void;
    getWindow(): Window | undefined;
    /** Called by client when the iframe is ready */
    setWindow(window: Window): void;
    postActiveThemes(): void;
    handleMessage(message: ComponentMessage): void;
    handleStreamContextItemMessage(message: ComponentMessage): void;
    handleSaveItemsMessage(message: ComponentMessage): Promise<void>;
    handleSetComponentDataMessage(message: ComponentMessage): void;
    getIframe(): HTMLIFrameElement | undefined;
}
export {};
