import { Uuid } from '@standardnotes/common';
import { SettingName, SubscriptionSettingName } from '@standardnotes/settings';
export declare const Paths: {
    v1: {
        changeCredentials: (userUuid: string) => string;
        deleteAccount: (userUuid: Uuid) => string;
        keyParams: string;
        refreshSession: string;
        register: string;
        session: (sessionUuid: string) => string;
        sessions: string;
        signIn: string;
        signOut: string;
        offlineFeatures: string;
        purchase: string;
        subscription: (userUuid: Uuid) => string;
        subscriptionTokens: string;
        userFeatures: (userUuid: string) => string;
        settings: (userUuid: Uuid) => string;
        setting: (userUuid: Uuid, settingName: SettingName) => string;
        subscriptionSetting: (userUuid: Uuid, settingName: SubscriptionSettingName) => string;
        listedRegistration: (userUuid: Uuid) => string;
        checkIntegrity: string;
        getSingleItem: (uuid: Uuid) => string;
        itemRevisions: (itemUuid: string) => string;
        itemRevision: (itemUuid: string, revisionUuid: string) => string;
        sync: string;
        closeUploadSession: string;
        createFileValetToken: string;
        deleteFile: string;
        downloadFileChunk: string;
        startUploadSession: string;
        uploadFileChunk: string;
    };
    v2: {
        keyParams: string;
        signIn: string;
        subscriptions: string;
    };
};
