import { FeatureDescription } from '@standardnotes/features';
import { SettingName, SubscriptionSettingName } from '@standardnotes/settings';
import { Uuid } from '@standardnotes/common';
import { AbstractService, ApiServiceInterface, InternalEventBusInterface, IntegrityApiInterface, ItemsServerInterface, ApiServiceEvent, MetaReceivedData, DiagnosticInfo, KeyValueStoreInterface } from '@standardnotes/services';
import { FilesApiInterface } from '@standardnotes/files';
import { ServerSyncPushContextualPayload, SNFeatureRepo, FileContent } from '@standardnotes/models';
import * as Responses from '@standardnotes/responses';
import { SNHttpService } from './HttpService';
import { Session } from '../Session/Sessions/Session';
import { DiskStorageService } from '../Storage/DiskStorageService';
import { HttpResponseMeta } from '@standardnotes/api';
import { UuidString } from '../../Types/UuidString';
import { SettingsServerInterface } from '../Settings/SettingsServerInterface';
import { SNRootKeyParams } from '@standardnotes/encryption';
import { ClientDisplayableError } from '@standardnotes/responses';
import { PureCryptoInterface } from '@standardnotes/sncrypto-common';
declare type InvalidSessionObserver = (revoked: boolean) => void;
export declare class SNApiService extends AbstractService<ApiServiceEvent.MetaReceived, MetaReceivedData> implements ApiServiceInterface, FilesApiInterface, IntegrityApiInterface, ItemsServerInterface, SettingsServerInterface {
    private httpService;
    private storageService;
    private host;
    private inMemoryStore;
    private crypto;
    protected internalEventBus: InternalEventBusInterface;
    private session?;
    user?: Responses.User;
    private registering;
    private authenticating;
    private changing;
    private refreshingSession;
    private invalidSessionObserver?;
    private filesHost?;
    constructor(httpService: SNHttpService, storageService: DiskStorageService, host: string, inMemoryStore: KeyValueStoreInterface<string>, crypto: PureCryptoInterface, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    setUser(user?: Responses.User): void;
    /**
     * When a we receive a 401 error from the server, we'll notify the observer.
     * Note that this applies only to sessions that are totally invalid. Sessions that
     * are expired but can be renewed are still considered to be valid. In those cases,
     * the server response is 498.
     * If the session has been revoked, then the observer will have its first
     * argument set to true.
     */
    setInvalidSessionObserver(observer: InvalidSessionObserver): void;
    loadHost(): void;
    setHost(host: string): Promise<void>;
    getHost(): string;
    isThirdPartyHostUsed(): boolean;
    getFilesHost(): string;
    setSession(session: Session, persist?: boolean): void;
    getSession(): Session | undefined;
    get apiVersion(): string;
    private params;
    createErrorResponse(message: string, status?: Responses.StatusCode): Responses.HttpResponse;
    private errorResponseWithFallbackMessage;
    processMetaObject(meta: HttpResponseMeta): void;
    private processResponse;
    private request;
    /**
     * @param mfaKeyPath  The params path the server expects for authentication against
     *                    a particular mfa challenge. A value of foo would mean the server
     *                    would receive parameters as params['foo'] with value equal to mfaCode.
     * @param mfaCode     The mfa challenge response value.
     */
    getAccountKeyParams(dto: {
        email: string;
        mfaKeyPath?: string;
        mfaCode?: string;
    }): Promise<Responses.KeyParamsResponse | Responses.HttpResponse>;
    signIn(dto: {
        email: string;
        serverPassword: string;
        ephemeral: boolean;
    }): Promise<Responses.SignInResponse | Responses.HttpResponse>;
    signOut(): Promise<Responses.SignOutResponse>;
    changeCredentials(parameters: {
        userUuid: UuidString;
        currentServerPassword: string;
        newServerPassword: string;
        newKeyParams: SNRootKeyParams;
        newEmail?: string;
    }): Promise<Responses.ChangeCredentialsResponse | Responses.HttpResponse>;
    sync(payloads: ServerSyncPushContextualPayload[], lastSyncToken: string, paginationToken: string, limit: number): Promise<Responses.RawSyncResponse | Responses.HttpResponse>;
    private refreshSessionThenRetryRequest;
    refreshSession(): Promise<Responses.SessionRenewalResponse | Responses.HttpResponse>;
    getSessionsList(): Promise<Responses.SessionListResponse | Responses.HttpResponse>;
    deleteSession(sessionId: UuidString): Promise<Responses.HttpResponse>;
    getItemRevisions(itemId: UuidString): Promise<Responses.RevisionListResponse | Responses.HttpResponse>;
    getRevision(entry: Responses.RevisionListEntry, itemId: UuidString): Promise<Responses.SingleRevisionResponse | Responses.HttpResponse>;
    getUserFeatures(userUuid: UuidString): Promise<Responses.HttpResponse | Responses.UserFeaturesResponse>;
    private tokenRefreshableRequest;
    listSettings(userUuid: UuidString): Promise<Responses.ListSettingsResponse>;
    updateSetting(userUuid: UuidString, settingName: string, settingValue: string | null, sensitive: boolean): Promise<Responses.UpdateSettingResponse>;
    getSetting(userUuid: UuidString, settingName: SettingName): Promise<Responses.GetSettingResponse>;
    getSubscriptionSetting(userUuid: UuidString, settingName: SubscriptionSettingName): Promise<Responses.GetSettingResponse>;
    deleteSetting(userUuid: UuidString, settingName: SettingName): Promise<Responses.DeleteSettingResponse>;
    deleteRevision(itemUuid: UuidString, entry: Responses.RevisionListEntry): Promise<Responses.MinimalHttpResponse>;
    downloadFeatureUrl(url: string): Promise<Responses.HttpResponse>;
    getSubscription(userUuid: string): Promise<Responses.HttpResponse | Responses.GetSubscriptionResponse>;
    getAvailableSubscriptions(): Promise<Responses.HttpResponse | Responses.GetAvailableSubscriptionsResponse>;
    getNewSubscriptionToken(): Promise<string | undefined>;
    downloadOfflineFeaturesFromRepo(repo: SNFeatureRepo): Promise<{
        features: FeatureDescription[];
    } | ClientDisplayableError>;
    registerForListedAccount(): Promise<Responses.ListedRegistrationResponse>;
    createFileValetToken(remoteIdentifier: string, operation: 'write' | 'read' | 'delete', unencryptedFileSize?: number): Promise<string | ClientDisplayableError>;
    startUploadSession(apiToken: string): Promise<Responses.StartUploadSessionResponse>;
    deleteFile(apiToken: string): Promise<Responses.MinimalHttpResponse>;
    uploadFileBytes(apiToken: string, chunkId: number, encryptedBytes: Uint8Array): Promise<boolean>;
    closeUploadSession(apiToken: string): Promise<boolean>;
    getFilesDownloadUrl(): string;
    downloadFile(file: {
        encryptedChunkSizes: FileContent['encryptedChunkSizes'];
    }, chunkIndex: number | undefined, apiToken: string, contentRangeStart: number, onBytesReceived: (bytes: Uint8Array) => Promise<void>): Promise<ClientDisplayableError | undefined>;
    checkIntegrity(integrityPayloads: Responses.IntegrityPayload[]): Promise<Responses.CheckIntegrityResponse>;
    getSingleItem(itemUuid: Uuid): Promise<Responses.GetSingleItemResponse>;
    private preprocessingError;
    /** Handle errored responses to authenticated requests */
    private preprocessAuthenticatedErrorResponse;
    getDiagnostics(): Promise<DiagnosticInfo | undefined>;
}
export {};
