import { ChallengeService } from '../Challenge';
import { ListedService } from '../Listed/ListedService';
import { ActionResponse } from '@standardnotes/responses';
import { ItemManager } from '../Items/ItemManager';
import { SNActionsExtension, Action, DecryptedItemInterface } from '@standardnotes/models';
import { SNSyncService } from '../Sync/SyncService';
import { PayloadManager } from '../Payloads/PayloadManager';
import { SNHttpService } from '../Api/HttpService';
import { AbstractService, DeviceInterface, InternalEventBusInterface, AlertService, EncryptionService } from '@standardnotes/services';
/**
 * The Actions Service allows clients to interact with action-based extensions.
 * Action-based extensions are mostly RESTful actions that can push a local value or
 * retrieve a remote value and act on it accordingly.
 * There are 4 action types:
 * `get`: performs a GET request on an endpoint to retrieve an item value, and merges the
 *      value onto the local item value. For example, you can GET an item's older revision
 *      value and replace the current value with the revision.
 * `render`: performs a GET request, and displays the result in the UI. This action does not
 *         affect data unless action is taken explicitely in the UI after the data is presented.
 * `show`: opens the action's URL in a browser.
 * `post`: sends an item's data to a remote service. This is used for example by Listed
 *       to allow publishing a note to a user's blog.
 */
export declare class SNActionsService extends AbstractService {
    private itemManager;
    private alertService;
    deviceInterface: DeviceInterface;
    private httpService;
    private payloadManager;
    private protocolService;
    private syncService;
    private challengeService;
    private listedService;
    protected internalEventBus: InternalEventBusInterface;
    private previousPasswords;
    constructor(itemManager: ItemManager, alertService: AlertService, deviceInterface: DeviceInterface, httpService: SNHttpService, payloadManager: PayloadManager, protocolService: EncryptionService, syncService: SNSyncService, challengeService: ChallengeService, listedService: ListedService, internalEventBus: InternalEventBusInterface);
    deinit(): void;
    getExtensions(): SNActionsExtension[];
    extensionsInContextOfItem(item: DecryptedItemInterface): SNActionsExtension[];
    /**
     * Loads an extension in the context of a certain item.
     * The server then has the chance to respond with actions that are
     * relevant just to this item. The response extension is not saved,
     * just displayed as a one-time thing.
     */
    loadExtensionInContextOfItem(extension: SNActionsExtension, item: DecryptedItemInterface): Promise<SNActionsExtension | undefined>;
    runAction(action: Action, item: DecryptedItemInterface): Promise<ActionResponse | undefined>;
    private handleRenderAction;
    private payloadByDecryptingResponse;
    private promptForLegacyPassword;
    private handlePostAction;
    private handleShowAction;
    private outgoingPayloadForItem;
}
