import { NoteMutator, SNNote, DecryptedItemInterface, PayloadEmitSource } from '@standardnotes/models';
import { SNApplication } from '../Application/Application';
import { ItemViewControllerInterface } from './ItemViewControllerInterface';
import { TemplateNoteViewControllerOptions } from './TemplateNoteViewControllerOptions';
export declare type EditorValues = {
    title: string;
    text: string;
};
export declare class NoteViewController implements ItemViewControllerInterface {
    private application;
    templateNoteOptions?: TemplateNoteViewControllerOptions | undefined;
    item: SNNote;
    dealloced: boolean;
    private innerValueChangeObservers;
    private removeStreamObserver?;
    isTemplateNote: boolean;
    private saveTimeout?;
    private defaultTagUuid;
    private defaultTag?;
    runtimeId: string;
    constructor(application: SNApplication, item?: SNNote, templateNoteOptions?: TemplateNoteViewControllerOptions | undefined);
    deinit(): void;
    initialize(addTagHierarchy: boolean): Promise<void>;
    private notifyObservers;
    private streamItems;
    insertTemplatedNote(): Promise<DecryptedItemInterface>;
    /**
     * Register to be notified when the controller's note's inner values change
     * (and thus a new object reference is created)
     */
    addNoteInnerValueChangeObserver(callback: (note: SNNote, source: PayloadEmitSource) => void): () => void;
    /**
     * @param bypassDebouncer Calling save will debounce by default. You can pass true to save
     * immediately.
     * @param isUserModified This field determines if the item will be saved as a user
     * modification, thus updating the user modified date displayed in the UI
     * @param dontUpdatePreviews Whether this change should update the note's plain and HTML
     * preview.
     * @param customMutate A custom mutator function.
     */
    save(dto: {
        editorValues: EditorValues;
        bypassDebouncer?: boolean;
        isUserModified?: boolean;
        dontUpdatePreviews?: boolean;
        customMutate?: (mutator: NoteMutator) => void;
    }): Promise<void>;
}
