import { FileItem, SNNote } from '@standardnotes/models';
import { SNApplication } from '../Application/Application';
import { NoteViewController } from './NoteViewController';
import { FileViewController } from './FileViewController';
import { TemplateNoteViewControllerOptions } from './TemplateNoteViewControllerOptions';
declare type ItemControllerGroupChangeCallback = (activeController: NoteViewController | FileViewController | undefined) => void;
declare type CreateItemControllerOptions = FileItem | SNNote | TemplateNoteViewControllerOptions;
export declare class ItemGroupController {
    private application;
    itemControllers: (NoteViewController | FileViewController)[];
    private addTagHierarchy;
    changeObservers: ItemControllerGroupChangeCallback[];
    eventObservers: (() => void)[];
    constructor(application: SNApplication);
    deinit(): void;
    createItemController(options: CreateItemControllerOptions): Promise<NoteViewController | FileViewController>;
    closeItemController(controller: NoteViewController | FileViewController, { notify }?: {
        notify: boolean;
    }): void;
    closeActiveItemController(): void;
    closeAllItemControllers(): void;
    get activeItemViewController(): NoteViewController | FileViewController | undefined;
    /**
     * Notifies observer when the active controller has changed.
     */
    addActiveControllerChangeObserver(callback: ItemControllerGroupChangeCallback): () => void;
    private notifyObservers;
}
export {};
