"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pinnedContent = exports.createFile = exports.createTagWithTitle = exports.createTagWithContent = exports.createNoteWithContent = exports.createNote = exports.mockUuid = void 0;
const common_1 = require("@standardnotes/common");
const ItemContent_1 = require("../../Abstract/Content/ItemContent");
const Payload_1 = require("../../Abstract/Payload");
const File_1 = require("../../Syncable/File");
const Note_1 = require("../../Syncable/Note");
const Tag_1 = require("../../Syncable/Tag");
let currentId = 0;
const mockUuid = () => {
    return `${currentId++}`;
};
exports.mockUuid = mockUuid;
const createNote = (payload) => {
    return new Note_1.SNNote(new Payload_1.DecryptedPayload(Object.assign({ uuid: (0, exports.mockUuid)(), content_type: common_1.ContentType.Note, content: (0, ItemContent_1.FillItemContent)(Object.assign({}, payload)) }, (0, Payload_1.PayloadTimestampDefaults)()), Payload_1.PayloadSource.Constructor));
};
exports.createNote = createNote;
const createNoteWithContent = (content, createdAt) => {
    return new Note_1.SNNote(new Payload_1.DecryptedPayload(Object.assign(Object.assign({ uuid: (0, exports.mockUuid)(), content_type: common_1.ContentType.Note, content: (0, ItemContent_1.FillItemContent)(content) }, (0, Payload_1.PayloadTimestampDefaults)()), { created_at: createdAt || new Date() }), Payload_1.PayloadSource.Constructor));
};
exports.createNoteWithContent = createNoteWithContent;
const createTagWithContent = (content) => {
    return new Tag_1.SNTag(new Payload_1.DecryptedPayload(Object.assign({ uuid: (0, exports.mockUuid)(), content_type: common_1.ContentType.Tag, content: (0, ItemContent_1.FillItemContent)(content) }, (0, Payload_1.PayloadTimestampDefaults)()), Payload_1.PayloadSource.Constructor));
};
exports.createTagWithContent = createTagWithContent;
const createTagWithTitle = (title = 'photos') => {
    return new Tag_1.SNTag(new Payload_1.DecryptedPayload(Object.assign({ uuid: (0, exports.mockUuid)(), content_type: common_1.ContentType.Tag, content: (0, ItemContent_1.FillItemContent)({ title }) }, (0, Payload_1.PayloadTimestampDefaults)()), Payload_1.PayloadSource.Constructor));
};
exports.createTagWithTitle = createTagWithTitle;
const createFile = (name = 'screenshot.png') => {
    return new File_1.FileItem(new Payload_1.DecryptedPayload(Object.assign({ uuid: (0, exports.mockUuid)(), content_type: common_1.ContentType.File, content: (0, ItemContent_1.FillItemContent)({ name }) }, (0, Payload_1.PayloadTimestampDefaults)()), Payload_1.PayloadSource.Constructor));
};
exports.createFile = createFile;
const pinnedContent = () => {
    return {
        appData: {
            'org.standardnotes.sn': {
                pinned: true,
            },
        },
    };
};
exports.pinnedContent = pinnedContent;
