import { PayloadSource } from './../../Abstract/Payload/Types/PayloadSource';
import { ImmutablePayloadCollection } from '../../Runtime/Collection/Payload/ImmutablePayloadCollection';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { FullyFormedPayloadInterface } from '../../Abstract/Payload/Interfaces/UnionTypes';
import { SyncResolvedPayload } from '../../Runtime/Deltas/Utilities/SyncResolvedPayload';
/**
 * Copies payload and assigns it a new uuid.
 * @returns An array of payloads that have changed as a result of copying.
 */
export declare function PayloadsByDuplicating<C extends ItemContent = ItemContent>(dto: {
    payload: FullyFormedPayloadInterface<C>;
    baseCollection: ImmutablePayloadCollection<FullyFormedPayloadInterface>;
    isConflict?: boolean;
    additionalContent?: Partial<C>;
    source?: PayloadSource;
}): SyncResolvedPayload[];
