import { ImmutablePayloadCollection } from '../../Runtime/Collection/Payload/ImmutablePayloadCollection';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { FullyFormedPayloadInterface } from '../../Abstract/Payload/Interfaces/UnionTypes';
import { SyncResolvedPayload } from '../../Runtime/Deltas/Utilities/SyncResolvedPayload';
/**
 * Return the payloads that result if you alternated the uuid for the payload.
 * Alternating a UUID involves instructing related items to drop old references of a uuid
 * for the new one.
 * @returns An array of payloads that have changed as a result of copying.
 */
export declare function PayloadsByAlternatingUuid<P extends DecryptedPayloadInterface = DecryptedPayloadInterface>(payload: P, baseCollection: ImmutablePayloadCollection<FullyFormedPayloadInterface>): SyncResolvedPayload[];
