import { ItemContent } from '../../Abstract/Content/ItemContent';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { DeletedPayloadInterface } from '../../Abstract/Payload/Interfaces/DeletedPayload';
import { EncryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/EncryptedPayload';
import { FullyFormedPayloadInterface } from '../../Abstract/Payload/Interfaces/UnionTypes';
export interface PayloadSplit<C extends ItemContent = ItemContent> {
    encrypted: EncryptedPayloadInterface[];
    decrypted: DecryptedPayloadInterface<C>[];
    deleted: DeletedPayloadInterface[];
}
export interface PayloadSplitWithDiscardables<C extends ItemContent = ItemContent> {
    encrypted: EncryptedPayloadInterface[];
    decrypted: DecryptedPayloadInterface<C>[];
    deleted: DeletedPayloadInterface[];
    discardable: DeletedPayloadInterface[];
}
export interface NonDecryptedPayloadSplit {
    encrypted: EncryptedPayloadInterface[];
    deleted: DeletedPayloadInterface[];
}
export declare function CreatePayloadSplit<C extends ItemContent = ItemContent>(payloads: FullyFormedPayloadInterface<C>[]): PayloadSplit<C>;
export declare function CreatePayloadSplitWithDiscardables<C extends ItemContent = ItemContent>(payloads: FullyFormedPayloadInterface<C>[]): PayloadSplitWithDiscardables<C>;
export declare function CreateNonDecryptedPayloadSplit(payloads: (EncryptedPayloadInterface | DeletedPayloadInterface)[]): NonDecryptedPayloadSplit;
