"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AffectorMapping = void 0;
const features_1 = require("@standardnotes/features");
const common_1 = require("@standardnotes/common");
const Component_1 = require("../../Syncable/Component");
const ItemGenerator_1 = require("../Item/ItemGenerator");
const MutationType_1 = require("../../Abstract/Item/Types/MutationType");
const Payload_1 = require("../../Abstract/Payload");
const NoteDuplicationAffectedPayloads = (basePayload, duplicatePayload, baseCollection) => {
    /** If note has editor, maintain editor relationship in duplicate note */
    const components = baseCollection
        .all(common_1.ContentType.Component)
        .filter(Payload_1.isDecryptedPayload)
        .map((payload) => {
        return (0, ItemGenerator_1.CreateDecryptedItemFromPayload)(payload);
    });
    const editor = components
        .filter((c) => c.area === features_1.ComponentArea.Editor)
        .find((e) => {
        return e.isExplicitlyEnabledForItem(basePayload.uuid);
    });
    if (!editor) {
        return [];
    }
    /** Modify the editor to include new note */
    const mutator = new Component_1.ComponentMutator(editor, MutationType_1.MutationType.NoUpdateUserTimestamps);
    mutator.associateWithItem(duplicatePayload.uuid);
    const result = mutator.getResult();
    return [result];
};
exports.AffectorMapping = {
    [common_1.ContentType.Note]: NoteDuplicationAffectedPayloads,
};
