import { ContentType } from '@standardnotes/common';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { MutationType } from '../../Abstract/Item/Types/MutationType';
import { DecryptedItemInterface } from '../../Abstract/Item/Interfaces/DecryptedItem';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { DecryptedItemMutator } from '../../Abstract/Item/Mutator/DecryptedItemMutator';
import { DeletedPayloadInterface, EncryptedPayloadInterface } from '../../Abstract/Payload';
import { EncryptedItemInterface } from '../../Abstract/Item/Interfaces/EncryptedItem';
import { DeletedItemInterface } from '../../Abstract/Item/Interfaces/DeletedItem';
declare type ItemClass<C extends ItemContent = ItemContent> = new (payload: DecryptedPayloadInterface<C>) => DecryptedItem<C>;
export declare function CreateDecryptedMutatorForItem<I extends DecryptedItemInterface, M extends DecryptedItemMutator = DecryptedItemMutator>(item: I, type: MutationType): M;
export declare function RegisterItemClass<C extends ItemContent = ItemContent, M extends DecryptedItemMutator<C> = DecryptedItemMutator<C>>(contentType: ContentType, itemClass: ItemClass<C>, mutatorClass: M): void;
export declare function CreateDecryptedItemFromPayload<C extends ItemContent = ItemContent, T extends DecryptedItemInterface<C> = DecryptedItemInterface<C>>(payload: DecryptedPayloadInterface<C>): T;
export declare function CreateItemFromPayload<C extends ItemContent = ItemContent, T extends DecryptedItemInterface<C> = DecryptedItemInterface<C>>(payload: DecryptedPayloadInterface<C> | EncryptedPayloadInterface | DeletedPayloadInterface): EncryptedItemInterface | DeletedItemInterface | T;
export {};
