import { ComponentArea } from '@standardnotes/features';
import { SNComponent } from '../Component/Component';
import { ConflictStrategy } from '../../Abstract/Item/Types/ConflictStrategy';
import { HistoryEntryInterface } from '../../Runtime/History';
import { DecryptedItemInterface, ItemInterface } from '../../Abstract/Item';
import { ThemePackageInfo } from '../Component/PackageInfo';
export declare const isTheme: (x: ItemInterface) => x is SNTheme;
export declare class SNTheme extends SNComponent {
    area: ComponentArea;
    readonly package_info: ThemePackageInfo;
    isLayerable(): boolean;
    /** Do not duplicate under most circumstances. Always keep original */
    strategyWhenConflictingWithItem(_item: DecryptedItemInterface, _previousRevision?: HistoryEntryInterface): ConflictStrategy;
    getMobileRules(): {};
    /** Same as getMobileRules but without default value. */
    hasMobileRules(): unknown;
    getNotAvailOnMobile(): unknown;
    isMobileActive(): unknown;
}
