import { SNTag } from './Tag';
import { TagContent } from './TagContent';
import { FileItem } from '../File';
import { SNNote } from '../Note';
import { DecryptedItemMutator } from '../../Abstract/Item/Mutator/DecryptedItemMutator';
import { TagPreferences } from './TagPreferences';
import { DecryptedItemInterface, MutationType } from '../../Abstract/Item';
export declare class TagMutator extends DecryptedItemMutator<TagContent> {
    private mutablePreferences?;
    constructor(item: DecryptedItemInterface<TagContent>, type: MutationType);
    set title(title: string);
    set expanded(expanded: boolean);
    set iconString(iconString: string);
    get preferences(): TagPreferences;
    set preferences(preferences: TagPreferences | undefined);
    makeChildOf(tag: SNTag): void;
    unsetParent(): void;
    addFile(file: FileItem): void;
    removeFile(file: FileItem): void;
    addNote(note: SNNote): void;
    removeNote(note: SNNote): void;
}
