import { VectorIconNameOrEmoji, IconType } from './../../Utilities/Icon/IconType';
import { Uuid } from '@standardnotes/common';
import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { ItemInterface } from '../../Abstract/Item/Interfaces/ItemInterface';
import { ContentReference } from '../../Abstract/Reference/ContentReference';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { TagContent, TagContentSpecialized } from './TagContent';
import { TagPreferences } from './TagPreferences';
export declare const TagFolderDelimitter = ".";
export declare const DefaultTagIconName: IconType;
export declare const isTag: (x: ItemInterface) => x is SNTag;
export declare class SNTag extends DecryptedItem<TagContent> implements TagContentSpecialized {
    readonly title: string;
    readonly iconString: VectorIconNameOrEmoji;
    readonly expanded: boolean;
    readonly preferences?: TagPreferences;
    constructor(payload: DecryptedPayloadInterface<TagContent>);
    get isDailyEntry(): boolean;
    get noteReferences(): ContentReference[];
    get noteCount(): number;
    get parentId(): Uuid | undefined;
    static arrayToDisplayString(tags: SNTag[]): string;
}
