import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { PredicateInterface } from '../../Runtime/Predicate/Interface';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { EmojiString, IconType } from '../../Utilities/Icon/IconType';
import { SmartViewContent } from './SmartViewContent';
import { TagPreferences } from '../Tag/TagPreferences';
import { ItemInterface } from '../../Abstract/Item';
export declare const SMART_TAG_DSL_PREFIX = "![";
export declare function isSystemView(view: SmartView): boolean;
export declare const isSmartView: (x: ItemInterface) => x is SmartView;
export declare class SmartView extends DecryptedItem<SmartViewContent> {
    readonly predicate: PredicateInterface<DecryptedItem>;
    readonly title: string;
    readonly iconString: IconType | EmojiString;
    readonly preferences?: TagPreferences;
    constructor(payload: DecryptedPayloadInterface<SmartViewContent>);
}
