import { NoteType } from '@standardnotes/features';
export declare type NoteBlock = {
    id: string;
    type: NoteType;
    editorIdentifier: string;
    size?: {
        width: number;
        height: number;
    };
    content: string;
};
export interface NoteBlocks {
    blocks: NoteBlock[];
}
export declare function bracketSyntaxForBlock(block: {
    id: NoteBlock['id'];
}): {
    open: string;
    close: string;
};
export declare function stringIndexOfBlock(text: string, block: {
    id: NoteBlock['id'];
}): {
    begin: number;
    end: number;
} | undefined;
export declare function blockContentToNoteTextRendition(block: {
    id: NoteBlock['id'];
}, content: string): string;
