import { FeatureIdentifier, NoteType } from '@standardnotes/features';
import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { ItemInterface } from '../../Abstract/Item/Interfaces/ItemInterface';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { NoteContent, NoteContentSpecialized } from './NoteContent';
export declare const isNote: (x: ItemInterface) => x is SNNote;
export declare class SNNote extends DecryptedItem<NoteContent> implements NoteContentSpecialized {
    readonly title: string;
    readonly text: string;
    readonly hidePreview: boolean;
    readonly preview_plain: string;
    readonly preview_html: string;
    readonly spellcheck?: boolean;
    readonly noteType?: NoteType;
    readonly authorizedForListed: boolean;
    /** The package_info.identifier of the editor (not its uuid), such as org.standardnotes.advanced-markdown */
    readonly editorIdentifier?: FeatureIdentifier | string;
    constructor(payload: DecryptedPayloadInterface<NoteContent>);
}
