import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { FileMetadata } from './FileMetadata';
import { FileProtocolV1 } from './FileProtocolV1';
import { SortableItem } from '../../Runtime/Collection/CollectionSort';
import { ConflictStrategy, ItemInterface } from '../../Abstract/Item';
declare type EncryptedBytesLength = number;
declare type DecryptedBytesLength = number;
interface SizesDeprecatedDueToAmbiguousNaming {
    size?: DecryptedBytesLength;
    chunkSizes?: EncryptedBytesLength[];
}
interface Sizes {
    decryptedSize: DecryptedBytesLength;
    encryptedChunkSizes: EncryptedBytesLength[];
}
interface FileContentWithoutSize {
    remoteIdentifier: string;
    name: string;
    key: string;
    encryptionHeader: string;
    mimeType: string;
}
export declare type FileContentSpecialized = FileContentWithoutSize & FileMetadata & SizesDeprecatedDueToAmbiguousNaming & Sizes;
export declare type FileContent = FileContentSpecialized & ItemContent;
export declare const isFile: (x: ItemInterface) => x is FileItem;
export declare class FileItem extends DecryptedItem<FileContent> implements FileContentWithoutSize, Sizes, FileProtocolV1, FileMetadata, SortableItem {
    readonly remoteIdentifier: string;
    readonly name: string;
    readonly key: string;
    readonly encryptionHeader: string;
    readonly mimeType: string;
    readonly decryptedSize: DecryptedBytesLength;
    readonly encryptedChunkSizes: EncryptedBytesLength[];
    constructor(payload: DecryptedPayloadInterface<FileContent>);
    strategyWhenConflictingWithItem(item: FileItem): ConflictStrategy;
    get encryptedSize(): number;
    get title(): string;
}
export {};
